/***************************************************************************
 *
 * knetworkmanager-vpnc.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_PPTP_H
#define KNETWORKMANAGER_PPTP_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqlayout.h>

#include "knetworkmanager-vpnplugin.h"
#include "pptpprop.h"
#include "pptpauth.h"

class PPTPPlugin : public VPNPlugin
{
	Q_OBJECT
	public:
		PPTPPlugin(TQObject*, const char*, const TQStringList&);
		~PPTPPlugin();

		VPNConfigWidget* CreateConfigWidget(TQWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent=0);
};

class PPTPConfig : public VPNConfigWidget
{
	Q_OBJECT
	public:
		void setVPNData(const TQStringList& routes, const TQMap<TQString, TQString>& properties);
		TQMap<TQString, TQString> getVPNProperties();
		TQStringList getVPNRoutes();
		bool hasChanged();
		bool isValid(TQStringList& );

		PPTPConfig(TQWidget* parent);
		~PPTPConfig();

	private:
		PPTPConfigWidget*   _pptpWidget;

	protected slots:
		void languageChange();
};

class PPTPAuthentication : public VPNAuthenticationWidget
{
	Q_OBJECT
	public:
		PPTPAuthentication(TQWidget* parent = NULL, char* name = NULL);
		~PPTPAuthentication();
		TQMap<TQString, TQString> getPasswords();
		void setPasswords(TQString name, TQString value);

	private:
		PPTPAuthenticationWidget* _pptpAuth;
};

#endif /* KNETWORKMANAGER_PPTP_H */
