/*
Copyright 2008 Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License or (at your option) version 3 or any later version
accepted by the membership of KDE e.V. (or its successor approved
by the membership of KDE e.V.), which shall act as a proxy 
defined in Section 14 of version 3 of the license.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TRAY_COMPONENT_H
#define TRAY_COMPONENT_H

#include <NetworkManager.h>

#include <tqmap.h>
#include <tqmovie.h>
#include <tqobject.h>
#include <tqpixmap.h>

class KPopupMenu;
class KSystemTray;

class TrayComponent : public QObject
{
Q_OBJECT
public:
    TrayComponent(KSystemTray * parent, const char * name );
    virtual ~TrayComponent();
    virtual void addMenuItems(KPopupMenu* menu) = 0;
    KSystemTray * tray() const;;
    virtual TQStringList getToolTipText();
signals:
    void uiUpdated();
private:
    KSystemTray * m_tray;
};
#endif // TRAY_COMPONENT_H
