/***************************************************************************
 *
 * main.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <dcopclient.h>
#include <dcopref.h>

// Qt includes
#include <tqtimer.h>

// KNM includes
#include "knetworkmanager.h"


static const char* knm_version = I18N_NOOP(KNETWORKMANAGER_VERSION_STRING);
static const char* knm_descr   = I18N_NOOP("A NetworkManager front-end for KDE");
static const char* knm_copy    = I18N_NOOP("Copyright (C) 2005, 2006 Novell, Inc.");
static const char* knm_webpage = I18N_NOOP("http://opensuse.org/Projects/KNetworkManager");

extern "C" KDE_EXPORT int
kdemain (int argc, char* argv[])
{
	KAboutData aboutData ("knetworkmanager", I18N_NOOP("KNetworkManager"),
			      knm_version, knm_descr, KAboutData::License_GPL,
			      knm_copy, 0, knm_webpage );

	aboutData.addAuthor ("Helmut Schaa", I18N_NOOP("Maintainer"), "hschaa@suse.de");
	aboutData.addAuthor ("Timo Hoenig", I18N_NOOP("Maintainer"), "thoenig@suse.de");
	aboutData.addAuthor ("Will Stephenson", I18N_NOOP("Additional code"), "wstephenson@suse.de");
	aboutData.addAuthor ("Valentine Sinitsyn", I18N_NOOP("Additional code"), "e_val@inbox.ru");
	aboutData.addAuthor ("Stefan Bogner", I18N_NOOP("KWallet integration"), "sbogner@suse.de");

	KCmdLineArgs::init (argc, argv, &aboutData);

	if (KNetworkManager::start ()) {
		KNetworkManager app;
		app.disableSessionManagement ();
		return app.exec ();
	}
	return 0;
}
