/***************************************************************************
 *
 * knetworkmanager-wireless_manager.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// other includes
#include <time.h>

// QT DBus
#include <dbus/qdbusobjectpath.h>

// KNM includes
#include "knetworkmanager-wireless_manager.h"
#include "knetworkmanager-wireless_device.h"
#include "knetworkmanager-wireless_network.h"
#include "knetworkmanager-accesspoint.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-wireless_connection.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-devicestore.h"


TQValueList<WirelessNetwork> WirelessManager::getWirelessNetworks(WirelessDevice* dev, Q_UINT32 match)
{
	TQValueList<WirelessNetwork> nets;
	TQValueList<AccessPoint*> aps;
	// fetch all APs
	aps = WirelessManager::getAccessPoints(dev);
	
	// now group the APs together according to their security settings
	for (TQValueList<AccessPoint*>::Iterator apit = aps.begin(); apit != aps.end(); ++apit)
	{
		bool found = false;

		// no hidden APs
		AccessPoint * ap = *apit;
		if ( ap ) {
			if (!ap->isValid())
				continue;

			if (ap->getSsid().count() == 0)
				continue;

			// check if we have a network matching this AP
			for (TQValueList<WirelessNetwork>::Iterator netIt = nets.begin(); netIt != nets.end(); ++netIt)
			{
				if ((*netIt).contains(ap) )
				{
					// we alread have a network where this AP belongs to
					found = true;

					// attach this ap to the network
					(*netIt).addAP(ap);

					/*				// FIXME active?
									if (active_ap)
									{
					// here is the active_ap
					if (!(*net).getActive() && ((*ap) == *active_ap))
					(*net).setActive(true);
					}*/
					break;
				}
			}

			if (!found)
			{
				// create a new network-descriptor according to this ap
				WirelessNetwork net(match);
				net.addAP(ap);
				nets.append(net);
			}
		}
	}	
	return nets;
}

TQValueList<AccessPoint*> WirelessManager::getAccessPoints(WirelessDevice* dev)
{
	// build up AP list depending on one device or on all devices
	if (dev) {
		return dev->accessPoints();
	}
	else {
		TQValueList<AccessPoint *> aps;
		DeviceStore* store = DeviceStore::getInstance();
		if (store)
		{
			TQValueList<Device*> devs = store->getDevices(DEVICE_TYPE_802_11_WIRELESS);
			for (TQValueList<Device*>::Iterator it = devs.begin(); it != devs.end(); ++it)
			{
				WirelessDevice* wdev = dynamic_cast<WirelessDevice*>(*it);
				if (!wdev)
					continue;
				// add all APs from this device
				aps +=wdev->accessPoints();
			}
		}
		return aps;
	}
}

TQValueList<WirelessConnection*> WirelessManager::getWirelessConnections()
{
	TQValueList<WirelessConnection*> conns;
	ConnectionStore* store = ConnectionStore::getInstance();

	// get all wireless connections
	TQValueList<Connection*> connections = store->getConnections(NM_SETTING_WIRELESS_SETTING_NAME);
	for (TQValueList<Connection*>::Iterator it = connections.begin(); it != connections.end(); ++it)
	{
		// cast to WirelessConnection*
		WirelessConnection* wireless_conn = dynamic_cast<WirelessConnection*>(*it);
		if (!wireless_conn)
			continue;
		conns.append(wireless_conn);
	}
    return conns;
}

TQValueList<AccessPoint*> WirelessManager::getAccessPointsForEssid(TQByteArray essid, WirelessDevice* dev)
{
	// build up AP list depending on one device or on all devices
	if (dev)
		return dev->accessPointsForEssid(essid);
	else
	{
        TQValueList<AccessPoint*> aps;
		DeviceStore* store = DeviceStore::getInstance();
		if (store)
		{
			TQValueList<Device*> devs = store->getDevices(DEVICE_TYPE_802_11_WIRELESS);
			for (TQValueList<Device*>::Iterator it = devs.begin(); it != devs.end(); ++it)
			{
				WirelessDevice* wdev = dynamic_cast<WirelessDevice*>(*it);
				if (!wdev)
					continue;
				// add all APs from this device
				aps += wdev->accessPointsForEssid(essid);
			}
		}
        return aps;
	}
}


