/***************************************************************************
 *
 * knetworkmanager-wireless_connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_WIRELESS_CONNECTION_H
#define KNETWORKMANAGER_WIRELESS_CONNECTION_H

#include <tqmap.h>
#include <tqobject.h>
#include <nm-setting-wireless.h>

#include "knetworkmanager-generic_connection.h"
#include "knetworkmanager-connection_setting.h"

class QDBusObjectPath;
namespace ConnectionSettings
{

	class Info;
	class Wireless;
	class WirelessSecurity;
	class IPv4;

	typedef TQMap<TQString, SettingsMap> ConnectionMap;

	class WirelessConnection : public GenericConnection
	{
		Q_OBJECT
		public:
			WirelessConnection();

			Wireless* getWirelessSetting() const;
			WirelessSecurity* getWirelessSecuritySetting() const;
			IPv4* getIPv4Setting() const;
			Connection* duplicate();
	};
}
#endif /* KNETWORKMANAGER_WIRELESS_CONNECTION_H */
