/***************************************************************************
 *
 * knetworkmanager-wireless_connection.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>
#include <tqvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDbus headers */
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>
#include <dbus/qdbusvariant.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-wireless_connection.h"
#include "knetworkmanager-connection_dbus.h"
#include "knetworkmanager-connection_secrets_dbus.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-connection_setting_8021x.h"
#include "knetworkmanager-nmsettings.h"

using namespace ConnectionSettings;

/*
	class WirelessConnection
*/
WirelessConnection::WirelessConnection()
	: GenericConnection(NM_SETTING_WIRELESS_SETTING_NAME)
{
	// create all settings needed for a wireless connection
	appendSetting(new IPv4(this));
	appendSetting(new Wireless(this));
	appendSetting(new WirelessSecurity(this));
	appendSetting(new IEEE8021x(this));
}

Wireless* WirelessConnection::getWirelessSetting() const
{
	return dynamic_cast<Wireless*>(getSetting(NM_SETTING_WIRELESS_SETTING_NAME));
}

WirelessSecurity* WirelessConnection::getWirelessSecuritySetting() const
{
	return dynamic_cast<WirelessSecurity*>(getSetting(NM_SETTING_WIRELESS_SECURITY_SETTING_NAME));
}

IPv4* WirelessConnection::getIPv4Setting() const
{
	return dynamic_cast<IPv4*>(getSetting(NM_SETTING_IP4_CONFIG_SETTING_NAME));
}

Connection* WirelessConnection::duplicate()
{
	WirelessConnection* conn = new WirelessConnection();
	conn->updateSettings(this);
	return conn;
}

#include "knetworkmanager-wireless_connection.moc"
