/***************************************************************************
 *
 * knetworkmanager-vpnmanager.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#define SERVICE_DIR "/etc/NetworkManager/VPN"

#include <klocale.h>
#include <tqdir.h>
#include <kdebug.h>
#include <kconfig.h>

#include "knetworkmanager-vpnmanager.h"
#include "knetworkmanager-vpnservice.h"
#include "knetworkmanager-vpnplugin.h"

/*
 *  class VPNManager
 *
 */
VPNServiceList
VPNManager::getVPNServices ()
{
	bool status = false;
	VPNServiceList list;
	
	TQDir serviceDir(SERVICE_DIR, TQString::null, TQDir::Name|TQDir::IgnoreCase, TQDir::Files);
	TQStringList services = serviceDir.entryList ().grep (".name", true);

	if (services.count () > 0)
	{	
		status = true;
		// read in all available Services
		for (TQStringList::Iterator i = services.begin (); i != services.end (); ++i) {
			TQString service = SERVICE_DIR + TQString ("/") + *i;
			KConfig* kconfig = new KConfig (service, true, true, "config");
			kconfig->setGroup ("VPN Connection");

kdDebug() << "VPN Service " << kconfig->readEntry ("name", TQString::null).ascii() << endl;

			// create new VPNService Object
			VPNService* vpnservice = new VPNService(kconfig->readEntry ("name", TQString::null), kconfig->readEntry ("service", TQString::null), KNetworkManager::getInstance());
			if (!vpnservice->getVPNPlugin())
				delete vpnservice;
			else
				list.push_back(vpnservice);
			delete kconfig;
		}
	}

	return list;
}

VPNService*
VPNManager::getVPNService(TQString service_type)
{
	bool status = false;
	VPNServiceList list;
	
	TQDir serviceDir(SERVICE_DIR, TQString::null, TQDir::Name|TQDir::IgnoreCase, TQDir::Files);
	TQStringList services = serviceDir.entryList ().grep (".name", true);

	if (services.count () > 0)
	{	
		status = true;
		// read in all available Services
		for (TQStringList::Iterator i = services.begin (); i != services.end (); ++i) {
			TQString service = SERVICE_DIR + TQString ("/") + *i;
			KConfig* kconfig = new KConfig (service, true, true, "config");
			kconfig->setGroup ("VPN Connection");

			if (kconfig->readEntry ("service", TQString::null) == service_type)
			{
				// create new VPNService Object
				VPNService* vpnservice = new VPNService(kconfig->readEntry ("name", TQString::null), kconfig->readEntry ("service", TQString::null), KNetworkManager::getInstance());
				if (!vpnservice->getVPNPlugin())
					delete vpnservice;
				else
					return vpnservice;
			}
		}
	}
	return NULL;

}

#include "knetworkmanager-vpnmanager.moc"
