/***************************************************************************
 *
 * knetworkmanager-vpn_plugin.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <tqhostaddress.h>

// QDBus includes
#include <dbus/qdbuserror.h>
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>

// NM includes
#include <NetworkManager.h>
#include <NetworkManagerVPN.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-tray.h"
#include "knetworkmanager-vpn_plugin.h"
#include "dbus/vpnpluginproxy.h"
#include "knetworkmanager-hal_device_proxy.h"
#include "knetworkmanager-nm_proxy.h"

unsigned int current_vpn_state = 0;
extern NMDeviceState nm_device_state_global;
extern QDBusObjectPath vpn_attempt_this_conn;
unsigned char vpn_new_credentials_needed = 0;

class VPNDBUSPluginPrivate
{
public:
	VPNDBUSPluginPrivate(TQString service, TQString obj_path)
		: nmVPNDBUS(service, obj_path)
	{}
	~VPNDBUSPluginPrivate() {}

	DBus::VPNPluginProxy nmVPNDBUS;
};

Q_UINT32 VPNDBUSPlugin::getState()
{
	QDBusError err;
	return d->nmVPNDBUS.getState(err);
}

void VPNDBUSPlugin::slotStateChanged(Q_UINT32 state)
{
	current_vpn_state = state+1;
	Tray* tray = Tray::getInstance();
	tray->slotUpdateDeviceState(nm_device_state_global);
	//emit StateChanged((NMDeviceState)state);
}

void VPNDBUSPlugin::slotLoginBanner(const TQString& banner)
{
	Tray* tray = Tray::getInstance();
	tray->slotVPNBannerShow(banner);
}

void VPNDBUSPlugin::slotFailure(Q_UINT32 failure_reason)
{
	printf("VPN failure code %d\n\r", failure_reason);

	if ((failure_reason == 0) || (failure_reason == 1) || (failure_reason == 2)) {
		// Try to connect again using cached information; request new login though
		printf("Reactivate VPN connection on default device\n\r");
		vpn_new_credentials_needed = 1;
		int id;
		QDBusError err;
		NMProxy* nm = NMProxy::getInstance();
		QDBusObjectPath act_conn = nm->getDefaultActiveConnection();
		QDBusObjectPath device   = nm->getDeviceForActiveConnection(act_conn);
		nm->ActivateConnectionAsync(id,NM_DBUS_SERVICE_USER_SETTINGS, vpn_attempt_this_conn, device, act_conn, err);
	}
}

VPNDBUSPlugin::VPNDBUSPlugin ()
	: TQObject()
{
	d = new VPNDBUSPluginPrivate(NM_VPN_DBUS_PLUGIN_INTERFACE, NM_VPN_DBUS_PLUGIN_PATH);
	d->nmVPNDBUS.setConnection(QDBusConnection::systemBus());

	// Connect the state changed signal to the handler
	connect(&(d->nmVPNDBUS), TQT_SIGNAL(StateChanged(Q_UINT32)), this, TQT_SLOT(slotStateChanged(Q_UINT32)));

	// Connect the failure signal to the handler
	connect(&(d->nmVPNDBUS), TQT_SIGNAL(Failure(Q_UINT32)), this, TQT_SLOT(slotFailure(Q_UINT32)));

	// And the banner signal
	connect(&(d->nmVPNDBUS), TQT_SIGNAL(LoginBanner(const TQString&)), this, TQT_SLOT(slotLoginBanner(const TQString&)));
}

VPNDBUSPlugin::~VPNDBUSPlugin ()
{
	delete d;
}


#include "knetworkmanager-vpn_plugin.moc"
