/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig       <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson   <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Helmut Schaa      <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *         Alexander Naumov  <anaumov@suse.de>, <posix.ru@gmail.com> 
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_TRAY_H
#define KNETWORKMANAGER_TRAY_H

#include <tqmap.h>
#include <tqtimer.h>

#include <tqtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <kpopupmenu.h>
#include <kactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <tqdialog.h>
#include <tqwidget.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqprogressbar.h>
#include <tqguardedptr.h>

#include "knetworkmanager.h"

namespace ConnectionSettings
{
	class Connection;
	class ConnectionSetting;
}

class TQMouseEvent;
class TrayComponent;
class TrayPrivate;
class TQDialog;
class TQPushButton;
class TQLabel;

class Tray : public KSystemTray
{
	Q_OBJECT

	public:
	  Tray ();
	  ~Tray ();
		static Tray* getInstance();
		void contextMenuAboutToShow (KPopupMenu* menu);
	
	signals:

	public slots:
		void slotOfflineMode();
		void slotOnlineMode();
		void slotEnableWireless();
		void slotDisableWireless();
		void slotEditConnections();

		void slotStateChanged(Q_UINT32 state);
		void slotVPNSecretsNeeded(ConnectionSettings::Connection* connection, ConnectionSettings::ConnectionSetting* setting, const TQStringList& hints, bool request_new);
		void slotSecretsNeeded(ConnectionSettings::Connection* connection, ConnectionSettings::ConnectionSetting* setting, const TQStringList& hints, bool request_new);

		void slotDeviceAddedNotify(Device*);
		void slotDeviceRemovedNotify(Device*);
		void slotStateChangedNotify(Q_UINT32 state);

		void slotUpdateDeviceState();
		void slotUpdateDeviceState(NMDeviceState);

		void slotNewVPNConnection();
		void slotVPNBannerShow(const TQString& vpnbanner);

  protected slots:
		void updateDeviceTrays();
		void slotAddDeviceTrayComponent(Device*);
		void slotRemoveDeviceTrayComponent(Device*);
		void slotDeactivateConnection(int);
		void trayComponentNeedsCenterStage(TrayComponent*, bool);
		void trayUiChanged();
		void slotEditNotifications();

	private:
		void updateTrayIcon(NMDeviceState);
		void updateActiveConnection(NMDeviceState);
		void mousePressEvent( TQMouseEvent *e );
		void createVPNTrayComponent();
		void createDeviceTrayComponent(Device*);
		void enterEvent (TQEvent*);

		TrayPrivate* d;

};

class NewSecretsDialog : public QDialog
{
	Q_OBJECT

	public:
		NewSecretsDialog(ConnectionSettings::Connection* connection, TQWidget * parent, const char * name, bool modal = false, Qt::WFlags f = 0);
		~NewSecretsDialog();
		void init();

	public slots:
		void slotDialogEdit();
		void reject();

	private:
		ConnectionSettings::Connection* _connection;
};

#endif /* KNETWORKMANAGER_TRAY_H */
