/***************************************************************************
 *
 * knetworkmanager-nminfo_dbus.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <stdlib.h>
#include <kdebug.h>

#include <NetworkManager.h>

#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusconnection.h>

#include "knetworkmanager.h"
#include "knetworkmanager-nmsettings.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-connection.h"

class NMSettingsPrivate
{
	public:
		NMSettingsPrivate()
			: obj_path_index(0)
		{

		}

		~NMSettingsPrivate()
		{

		}

		int obj_path_index;
};


NMSettings* NMSettings::_instance = NULL;

NMSettings* NMSettings::getInstance()
{
	// return singleton instance
	if (_instance)
		return _instance;
	return (_instance = new NMSettings());
}

NMSettings::NMSettings()
{
	d = new NMSettingsPrivate();
	QDBusConnection conn = QDBusConnection::systemBus();

	kdDebug() << "NMSettings::NMSettings" << endl;

	// request the name for the settings interface
	if (!conn.requestName(NM_DBUS_SERVICE_USER_SETTINGS))
		kdError() << "req name failed for " << NM_DBUS_SERVICE_USER_SETTINGS << endl;

	// request the name for the connections here too
	if (!conn.requestName(NM_DBUS_IFACE_SETTINGS_CONNECTION))
		kdError() << "req name failed for " << NM_DBUS_IFACE_SETTINGS_CONNECTION << endl;

	// request the name for the connections here too
	if (!conn.requestName(NM_DBUS_IFACE_SETTINGS_CONNECTION_SECRETS))
		kdError() << "req name failed for " << NM_DBUS_IFACE_SETTINGS_CONNECTION_SECRETS << endl;

	// register on the DBus
	if (!conn.registerObject(objectPath(), this))
		kdError() << "registerobjectpath failed" << endl;


	ConnectionStore* cstore = ConnectionStore::getInstance();

	// we need to get informed about new connections...
	connect(cstore, TQT_SIGNAL(signalConnectionAdded(ConnectionSettings::Connection*)), this, TQT_SLOT(slotNewConnection(ConnectionSettings::Connection*)));
}

NMSettings::~NMSettings()
{
	delete d;
	QDBusConnection conn = QDBusConnection::systemBus();
	conn.unregisterObject(NM_DBUS_PATH_SETTINGS);
}


bool NMSettings::handleSignalSend(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
	return true;
}

TQString NMSettings::objectPath() const
{
	return TQString(NM_DBUS_PATH_SETTINGS);
}

bool NMSettings::ListConnections(TQValueList<QDBusObjectPath>& connections, QDBusError& /*error*/)
{
	// return connections
	ConnectionStore* cstore = ConnectionStore::getInstance();
	TQValueList<ConnectionSettings::Connection*> conns = cstore->getConnections();

	for (TQValueList<ConnectionSettings::Connection*>::Iterator it = conns.begin(); it != conns.end(); ++it)
	{
		ConnectionSettings::Connection* conn = (*it);
		connections.append(conn->getObjectPath());
	}

	return true;
}

void NMSettings::handleMethodReply(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
}

QDBusObjectPath
NMSettings::getObjPathForConnection()
{
	// just increase the number for this connection
	QDBusObjectPath obj_path(NM_DBUS_PATH_SETTINGS_CONNECTION"/");
	obj_path += TQString::number(d->obj_path_index++);
	return obj_path;
}

void
NMSettings::slotNewConnection(ConnectionSettings::Connection* conn)
{
	emitNewConnection(conn->getObjectPath());
}


#include "knetworkmanager-nmsettings.moc"
