/***************************************************************************
 *
 * knetworkmanager-device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>

// QtDBus includes
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusproxy.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatalist.h>
#include <dbus/qdbuserror.h>
#include <dbus/qdbusobjectpath.h>

// NM includes
#include <NetworkManager.h>
#include <NetworkManagerVPN.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-nm_vpn_proxy.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-devicestore.h"
//#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_store.h"
#include "dbus/vpnconnectionproxy.h"

class NMVPNProxyPrivate
{
	public:
		NMVPNProxyPrivate()
		{}

		static NMVPNProxy* nm;
};

NMVPNProxy* NMVPNProxyPrivate::nm = NULL;

NMVPNProxy::NMVPNProxy()
	: NetworkManagerVPNProxy(NM_DBUS_SERVICE, NM_DBUS_PATH_VPN_CONNECTION)
{
	d = new NMVPNProxyPrivate();
	NetworkManagerVPNProxy::setConnection(QDBusConnection::systemBus());
}

NMVPNProxy::~NMVPNProxy()
{
	delete d;
}

NMVPNProxy* NMVPNProxy::getInstance()
{
	if (NMVPNProxyPrivate::nm)
		return NMVPNProxyPrivate::nm;
	return (NMVPNProxyPrivate::nm = new NMVPNProxy());
}


#include "knetworkmanager-nm_vpn_proxy.moc"
