/***************************************************************************
 *
 * knetworkmanager-device_tray.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DEVICE_TRAY_H
#define KNETWORKMANAGER_DEVICE_TRAY_H

#include <tqmap.h>
#include <tqtimer.h>

#include <tqtooltip.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>
#include <kpopupmenu.h>
#include <kactionclasses.h>
#include <kstdaction.h>
#include <kstdguiitem.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqprogressbar.h>
#include <tqguardedptr.h>

#include <NetworkManager.h>
#include "knetworkmanager.h"

#define NM_DEVICE_STATE_VPN_PREPARE 100
#define NM_DEVICE_STATE_VPN_ACTIVATED 101

class Device;
class DeviceTrayPrivate;

class DeviceTray : public KSystemTray
{
	Q_OBJECT

	public:
	  DeviceTray (Device*);
	  ~DeviceTray ();

		void contextMenuAboutToShow (KPopupMenu* menu);
		virtual void addMenuItems(KPopupMenu* menu) = 0;
		Device* getDevice() const;

	protected:
		void setPixmapForState(NMDeviceState, TQMovie);
		void setPixmapForState(NMDeviceState, TQPixmap);
		void resizeEvent ( TQResizeEvent * );

		virtual TQString getTooltipText();

	public slots:
		void setPixmap(const TQPixmap &);
		void slotUpdateDeviceState(NMDeviceState);
		void slotUpdateDeviceState();

	private:
		void updateTrayIcon(NMDeviceState);
		void updateActions(NMDeviceState);
		void updateActiveConnection(NMDeviceState);
		void enterEvent (TQEvent*);
		void loadIcons();

		DeviceTrayPrivate* d;
		NMDeviceState m_currentIconState;
};

#endif /* KNETWORKMANAGER_DEVICE_TRAY_H */
