/***************************************************************************
 *
 * knetworkmanager-device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <NetworkManager.h>

#include "knetworkmanager.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-device.h"
#include "dbus/deviceproxy.h"
#include "knetworkmanager-hal_device_proxy.h"


#include <kdebug.h>
#include <tqhostaddress.h>

#include <dbus/qdbuserror.h>
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusproxy.h>


class NMDeviceProxy : public DBus::DeviceProxy
{
	public:
    NMDeviceProxy(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0)
			: DeviceProxy(service, path, parent, name)
		{

		}

		TQString getObjectPath() const
		{
			return m_baseProxy->path();
		}
};

class DevicePrivate
{
public:
	DevicePrivate(TQString service, TQString obj_path)
		: nmDevice(service, obj_path)
		, halDevice(NULL)
  {}
	~DevicePrivate() {}

	NMDeviceProxy nmDevice;
	HalDeviceProxy* halDevice;
};

Q_UINT32 Device::getDeviceType() const
{
	QDBusError err;
	Q_UINT32 type = d->nmDevice.getDeviceType(err);
	kdWarning() << k_funcinfo << err.name() << err.message() << endl;
	return type;
}

TQString Device::getInterface() const
{
	QDBusError err;
	return d->nmDevice.getInterface(err);
}

TQString Device::getUdi() const
{
	QDBusError err;
	return d->nmDevice.getUdi(err);
}

TQString Device::getDriver() const
{
	QDBusError err;
	return d->nmDevice.getDriver(err);
}

Q_UINT32 Device::getCapabilities() const
{
	QDBusError err;
	return d->nmDevice.getCapabilities(err);
}

Q_INT32 Device::getIp4Address() const
{
	QDBusError err;
	return d->nmDevice.getIp4Address(err);
}

NMDeviceState Device::getState() const
{
	QDBusError err;
	return (NMDeviceState)d->nmDevice.getState(err);
}

TQString Device::getVendor() const
{
	// FIXME: ask hal
	return "";
}

TQString Device::getProduct() const
{
	// FIXME: ask hal
	return "";
}

TQString Device::getObjectPath() const
{
	return d->nmDevice.getObjectPath();
}

void Device::slotStateChanged(Q_UINT32 state)
{
	emit StateChanged((NMDeviceState)state);
}

void Device::slotDeactivate()
{
	// FIXME: the method was removed from NM API, use nm_proxy instead
	NMProxy* nm = NMProxy::getInstance();

	nm->deactivateDevice(this);

//	QDBusError err;
//	d->nmDevice.Deactivate(err);
}

Device::Device (const TQString & obj_path)
{
	d = new DevicePrivate(NM_DBUS_SERVICE, obj_path);

	// create the NM Device Proxy
	d->nmDevice.setConnection(QDBusConnection::systemBus());

	connect(&(d->nmDevice), TQT_SIGNAL(StateChanged(Q_UINT32)), this, TQT_SLOT(slotStateChanged(Q_UINT32)));
//	d->halDevice = new HalDeviceProxy();
}

Device::~Device ()
{
//	delete d->halDevice;
	delete d;
}


#include "knetworkmanager-device.moc"
