/***************************************************************************
 *
 * knetworkmanager-connection_store.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_STORE_H
#define KNETWORKMANAGER_CONNECTION_STORE_H

#include <tqvaluelist.h>
#include <tqobject.h>

namespace ConnectionSettings
{
	class Connection;
	class ConnectionSetting;
}

using namespace ConnectionSettings;

class ConnectionStore : public QObject
{
	Q_OBJECT

	public:
		static ConnectionStore* getInstance();
		~ConnectionStore();

		// add a new connection to the store
		void addConnection(ConnectionSettings::Connection*);

		// get all connections
		TQValueList<ConnectionSettings::Connection*> getConnections(const TQString& type = TQString::null);

		// get a connection by ID
		ConnectionSettings::Connection* getConnection(const TQString&);

		// delete the specified connection from the store and delete it
		void removeConnection(ConnectionSettings::Connection*);

	public slots:
		// has to be called as response to the signal SecretsNeeded
		void slotSecretsNeeded(Connection* connection, ConnectionSetting* setting, const TQStringList& hints, bool request_new);

	signals:
		// emitted when a new connection is added to the store
		void signalConnectionAdded(ConnectionSettings::Connection*);

		// emitted when a connection was updated
		void signalConnectionUpdated(ConnectionSettings::Connection*);

		// emitted when a connection is removed from the store
		void signalConnectionRemoved(ConnectionSettings::Connection*);

		// emitted when a connection needs new secrets
		void SecretsNeeded(ConnectionSettings::Connection* connection, ConnectionSettings::ConnectionSetting* setting, const TQStringList& hints, bool request_new);

	private slots:
		void slotInit();

	private:
		ConnectionStore();
		TQString createNewConnectionID();

		TQValueList<ConnectionSettings::Connection*> _connectionList;
		static ConnectionStore* _instance;
};

#endif /* KNETWORKMANAGER_CONNECTION_STORE_H */
