/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_WIDGET_H
#define KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_WIDGET_H

#include "knetworkmanager-connection_setting_widget_interface.h"
#include "connection_setting_wireless.h"
#include "knetworkmanager-connection_setting.h"

class KListViewSearchLineWidget;

namespace ConnectionSettings
{
	class Wireless;
	class WirelessSecurity;
	class Info;


	class WirelessWidgetImpl : public WidgetInterface
	{
		Q_OBJECT
		public:
			WirelessWidgetImpl(Connection* conn, bool new_conn, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0);

			void Activate();

		public slots:
			void slotEssidChanged(const TQString& new_essid);
			void slotEssidChanged(TQListViewItem*);
			void slotEssidDoubleClicked(TQListViewItem*, const TQPoint&, int);

		private:
			void Init();
			void updateEssid(const TQByteArray&);
			TQByteArray byteArrayFromHexString(const TQCString&);
			TQString    hexStringFromByteArray(const TQByteArray& );
	
			bool      _hasName;
			Wireless* _wireless_setting;
			Info*     _info_setting;
			WirelessSecurity* _security_setting;
			ConnectionSettingWirelessWidget* _mainWid;
			KListViewSearchLineWidget* _searchLine;
			bool _new_conn;
	};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_WIRELESS_WIDGET_H*/
