/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_WIRED_H
#define KNETWORKMANAGER_CONNECTION_SETTING_WIRED_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>

#include <dbus/qdbusdata.h>
#include "knetworkmanager-connection_setting.h"
#include <nm-setting-wired.h>

namespace ConnectionSettings
{

// setting for wired interfaces
class Wired: public ConnectionSetting
{
	public:
		Wired(Connection* conn, TQString port = TQString::null, uint32_t speed = 0, TQString duplex = TQString::null, bool autoNegotiate = true, TQByteArray macAddress = TQByteArray(), uint32_t mtu = 0);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		bool isValid() const;

	private:
		TQString    _port;
		uint32_t   _speed;
		TQString    _duplex;
		bool       _autoNegotiate;
		TQByteArray _macAddress;
		uint32_t   _mtu;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_WIRED_H */
