/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDBus headers*/
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>

/* NM headers */
#include <nm-setting-wired.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-accesspoint.h"


using namespace ConnectionSettings;
/*
	class Wired
*/
Wired::Wired(Connection* conn, TQString port, uint32_t speed, TQString duplex, bool autoNegotiate, TQByteArray macAddress, uint32_t mtu)
	: ConnectionSetting(conn, NM_SETTING_WIRED_SETTING_NAME)
{
	_port = port;
	_speed = speed;
	_duplex = duplex;
	_autoNegotiate = autoNegotiate;
	_macAddress = macAddress;
	_mtu = mtu;
}

SettingsMap
Wired::toMap() const
{
	SettingsMap map;

	if (!_port.isNull())
		map.insert(NM_SETTING_WIRED_PORT, QDBusData::fromString(_port));

	map.insert(NM_SETTING_WIRED_SPEED, QDBusData::fromUInt32(_speed));
	
	if (!_duplex.isNull())
		map.insert(NM_SETTING_WIRED_DUPLEX, QDBusData::fromString(_duplex));

	map.insert(NM_SETTING_WIRED_AUTO_NEGOTIATE, QDBusData::fromBool(_autoNegotiate));

	//FIXME
/*
	if (!_macAddress.isNull())
		map.insert(NM_SETTING_WIRED_MAC_ADDRESS, QDBusData::from(_macAddress));
*/
	map.insert(NM_SETTING_WIRED_MTU, QDBusData::fromUInt32(_mtu));

	return map;
}

void
Wired::fromMap(const SettingsMap& map)
{
	SettingsMap::ConstIterator it;

	// TODO

}

bool
Wired::isValid() const
{
	return true;
}
