/***************************************************************************
 *
 * knetworkmanager-connection_setting_vpn.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_VPN_H
#define KNETWORKMANAGER_CONNECTION_SETTING_VPN_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>
#include <tqdatetime.h>

#include <dbus/qdbusdata.h>
#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-vpn.h>

namespace ConnectionSettings
{

// info setting
class VPN : public ConnectionSetting
{
	public:
		VPN(Connection* conn);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		SettingsMap toSecretsMap(bool with_settings = true) const;
		bool        fromSecretsMap(const SettingsMap&);

		TQString     getUserName() const;
		void        setUserName(const TQString&);

		TQString     getServiceType() const;
		void        setServiceType(const TQString&);

		TQValueList<TQString> getRoutes() const;
		void        setRoutes(const TQValueList<TQString>&);

		TQMap<TQString, TQString>   getData() const;
		void                     setData(TQMap<TQString, TQString> data);

		// Ugh, that is ugly
		TQMap<TQString, TQString>   getSecrets() const;
		void                     setSecrets(const TQMap<TQString, TQString>& secrets);

		bool        isValid() const;

	private:
		TQString             _userName;
		TQString             _serviceType;
		TQValueList<TQString> _routes;
		TQMap<TQString, TQString> _data;
		TQMap<TQString, TQString> _secrets;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_VPN_H */
