/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_IPV4_H
#define KNETWORKMANAGER_CONNECTION_SETTING_IPV4_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>

#include <dbus/qdbusdata.h>

#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-ip4-config.h>

namespace ConnectionSettings
{

class Connection;

class IPv4Address
{
	public:
		TQHostAddress address;
		TQHostAddress netmask;
		TQHostAddress gateway;
};

// ipv4 setting
class IPv4 : public ConnectionSetting
{
	public:
		enum IPV4METHOD
		{
			METHOD_DHCP = 1
		, METHOD_AUTO = METHOD_DHCP  // DHCP is obsolete now
		, METHOD_AUTOIP
		, METHOD_LINK_LOCAL = METHOD_AUTOIP // AUTOIP is obsolete now
		, METHOD_MANUAL
		, METHOD_SHARED
		};

		IPv4(Connection* conn);

		SettingsMap toMap() const;
		void        fromMap(const SettingsMap&);

		void     addAddress(const IPv4Address&);
		void     removeAddress(const IPv4Address&);

		TQValueList<IPv4Address> getAddresses() const;
		void     setAddresses(const TQValueList<IPv4Address>&);

		TQValueList<TQHostAddress> getDNS() const;
		void     setDNS(const TQValueList<TQHostAddress>&);

		TQStringList getDNSSearch() const;
		void        setDNSSearch(const TQStringList&);

		void     setMethod(IPV4METHOD);
		IPV4METHOD getMethod() const;

		void setIgnoreAutoDNS(bool);
		bool getIgnoreAutoDNS() const;

		void setIgnoreAutoRoutes(bool);
		bool getIgnoreAutoRoutes() const;

		bool     isValid() const;
		
		bool     useSetting();

		Q_UINT32 toCIDRSuffix(const TQHostAddress&) const;
		TQHostAddress fromCIDRSuffix(Q_UINT32 suffix);

	private:
		TQValueList<TQHostAddress> _dns;
		TQStringList              _dns_search;
		TQValueList<IPv4Address>  _addresses;
		IPV4METHOD               _method;
		bool                     _ignore_auto_dns;
		bool                     _ignore_auto_routes;

		// TODO routes, dhcp-client-id, dhcp-hostname
};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_IPV4_H */
