/***************************************************************************
 *
 * knetworkmanager-connection_setting_cdma.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_CDMA_H
#define KNETWORKMANAGER_CONNECTION_SETTING_CDMA_H

#include <stdint.h>
#include <tqhostaddress.h>
#include <tqmap.h>
#include <tqvariant.h>
#include <tqobject.h>

#include <dbus/qdbusdata.h>

#include "knetworkmanager-connection_setting.h"

/* NM headers */
#include <nm-setting-cdma.h>

namespace ConnectionSettings
{

class Connection;

// serial setting
class CDMA : public ConnectionSetting
{
	public:
		CDMA(Connection* conn);

		SettingsMap toMap() const;
		SettingsMap toSecretsMap(bool with_settings = true) const;
		void        fromMap(const SettingsMap&);
		bool        fromSecretsMap(const SettingsMap&);

		bool     isValid() const;
		bool     useSetting();

		void     setNumber(const TQString&);
		TQString  getNumber() const;

		void     setUsername(const TQString&);
		TQString  getUsername() const;

		void     setPassword(const TQString&);
		TQString  getPassword() const;

	private:
		TQString _number;
		TQString _username;
		TQString _password;
};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_CDMA_H */
