/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <tqhostaddress.h>
#include <tqvariant.h>
#include <tqvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDbus headers */
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatalist.h>
#include <dbus/qdbusdatamap.h>
#include <dbus/qdbusvariant.h>
#include <dbus/qdbuserror.h>
#include <dbus/qdbusmessage.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_secrets_dbus.h"
#include "knetworkmanager-connection_dbus.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-accesspoint.h"
#include "knetworkmanager-nmsettings.h"
#include "xmlmarshaller.h"
#include "stdio.h"

using namespace ConnectionSettings;

namespace ConnectionSettings
{

class ConnectionSecretsDBusPrivate
{
	public:
		ConnectionSecretsDBusPrivate(Connection* par)
			: parent(par)
      , currentRequest(-1)
    {}
		~ConnectionSecretsDBusPrivate() {}

		Connection* parent;
		int         currentRequest;
};

}

/*
	class Connection
*/
ConnectionSecretsDBus::ConnectionSecretsDBus(Connection* parent)
	: TQObject(parent)
{
	d = new ConnectionSecretsDBusPrivate(parent);
}

ConnectionSecretsDBus::~ConnectionSecretsDBus()
{
	delete d;
}

void
ConnectionSecretsDBus::SendGetSecretsError()
{
	GetSecretsAsyncError(d->currentRequest, QDBusError::stdFailed("Requested setting is empty"));
}

void
ConnectionSecretsDBus::SendGetSecretsReply(ConnectionSettings::ConnectionSetting* setting)
{
	QDBusMessage reply;

	kdDebug() << "SendGetSecretsReply1 id " << d->currentRequest << endl;

	// if no secret is needed we should not send one, right?
	if (d->currentRequest < 0)
		return;
	kdDebug() << "SendGetSecretsReply2" << endl;
/*
	// no such setting
	if (!setting)
	{
		GetSecretsAsyncError(d->currentRequest, QDBusError::stdFailed("Requested setting is unknown"));
	}
	else
	{
	kdDebud() << "SendGetSecretsReply3" << endl;
		// copy the settingsmap over to a variantmap
		TQMap<TQString, QDBusData> map = setting->toSecretsMap();

		// only take used settings
		if (map.size() == 0)
		{
	kdDebug() << "SendGetSecretsReply4" << endl;
			GetSecretsAsyncError(d->currentRequest, QDBusError::stdFailed("Requested setting is empty"));
		}
		else
		{
	kdDebug() << "SendGetSecretsReply5" << endl;
			QDBusDataMap<TQString> secrets(map);
			
			TQMap<TQString, QDBusVariant> secrets;
			for (TQMap<TQString, QDBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
			{
				QDBusVariant var;
				var.value = it2.data();
				var.signature = var.value.buildDBusSignature();
				secrets.insert(it2.key(), var);
			}
	kdDebug() << "SendGetSecretsReply6" << endl;

			GetSecretsAsyncReply(d->currentRequest, secrets);
		}
	}*/

	QDBusDataMap<TQString> settings;
	TQValueList<ConnectionSetting*> all_settings = d->parent->getSettings();

	// FIXME: ugly conversions, ask Kevin on how to make it better
	for (TQValueList<ConnectionSetting*>::Iterator it = all_settings.begin(); it != all_settings.end(); ++it)
	{
		kdDebug() << "  Processing Setting '" << (*it)->getType().ascii() << "'" << endl;
		if (!(*it)->isValid())
		{
			kdDebug() << "  Setting '" << (*it)->getType().ascii() << "' is not valid, discarding" << endl;
			continue;
		}

		// copy the settingsmap over to a variantmap
		TQMap<TQString, QDBusData> map = (*it)->toSecretsMap();

		// only take used settings
		if (map.size() == 0)
		{
			kdDebug() << "  Setting '" << (*it)->getType().ascii() << "' is empty, discarding" << endl;
			continue;
		}

		kdDebug() << "  Attach setting '" << (*it)->getType().ascii() << "'" << endl;

		TQMap<TQString, QDBusVariant> variant_map;

		for (TQMap<TQString, QDBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
		{
			TQString dataxml = XMLMarshaller::fromQDBusData(it2.data());
			kdDebug() << "    " << it2.key().ascii() << ": " << dataxml.replace('\n', ' ').ascii() << endl;
			QDBusVariant var;
			var.value = it2.data();
			var.signature = var.value.buildDBusSignature();
			variant_map.insert(it2.key(), var);
		}

		// convert the variantma
		QDBusDataMap<TQString> map2 = QDBusDataMap<TQString>(variant_map);
		QDBusData data = QDBusData::fromStringKeyMap(map2);

		// insert this setting
		settings.insert((*it)->getType(), data);
	}
	
	GetSecretsAsyncReply(d->currentRequest, settings);
	d->currentRequest = -1;

}
	
void
ConnectionSecretsDBus::GetSecretsAsync(int id, const TQString& setting_name, const TQStringList& hints, bool request_new)
{
	printf("Connection::GetSecretsAsync for setting %s, %s\n\r", setting_name.ascii(), id);
	kdDebug() << "Connection::GetSecretsAsync for setting " << setting_name.ascii() << ", " << id << endl;
	d->currentRequest = id;
	emit SecretsNeeded(setting_name, hints, request_new);
}

void
ConnectionSecretsDBus::handleMethodReply(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
}

bool
ConnectionSecretsDBus::handleSignalSend(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
	return true;
}

QString
ConnectionSecretsDBus::objectPath() const
{
	return TQString(d->parent->getObjectPath());
}


#include "knetworkmanager-connection_secrets_dbus.moc"
