/***************************************************************************
 *   Copyright (C) 2007 by Frode M. Døving   *
 *   frode@lnix.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "kio_umountwrapper.h"

#include <cstdlib>
#include <qtimer.h>

#include <kapplication.h>
#include <klocale.h>
#include <kprogress.h>
#include <kprocess.h>
#include <kcmdlineargs.h>
#include <kdebug.h>

kio_umountwrapper::kio_umountwrapper(const QString& url)
    : KApplication( 0, "kio_umountwrapper" )
{
    m_progress = new KProgressDialog();
    setMainWidget(m_progress);    
    m_progress->setLabel(i18n("Synchronising data to disk, please wait")+"...");
    m_progress->setAutoClose(true);
    m_progress->setAllowCancel(false);
    m_progress->progressBar()->setTextEnabled(false);
    m_progress->progressBar()->setTotalSteps(0);
    m_progress->show();

    QTimer *t = new QTimer(this);
    connect(t, SIGNAL(timeout()), SLOT(progressAdvance()));
    t->start(10, FALSE);

    KProcess *p = new KProcess(this);
    *p << "kio_media_mounthelper";
    *p << "-s";
    *p << url;
    kdDebug() << "KProcess: " << url << endl;
    connect(p, SIGNAL(processExited(KProcess *)),
    this, SLOT(processFinished(KProcess *)));
    p->start();
}

void kio_umountwrapper::progressAdvance()
{
    m_progress->progressBar()->advance(1);
}

void kio_umountwrapper::processFinished(KProcess* p)
{
    if (p->normalExit() && p->exitStatus() == 0)
    {
        ::exit(0);
    }
    else
    {
        ::exit(1);
    }
}

#include "kio_umountwrapper.moc"
