/***************************************************************************
 *   Copyright (C) 2007 by Johannes Schaub                                 *
 *   schaub-johannes@web.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef UPDATEEVENT_H
#define UPDATEEVENT_H

#include <qevent.h>

/**
 * UpdateEvent is a custom event to update the QObject of the ThreadedTrigger periodically
 */
class UpdateEvent: public QCustomEvent{
public:
	UpdateEvent(const QString& inMessage);
	static const int TYPE = QEvent::User + 1;
	const QString& getMessage() const;
private:	
	QString mMessage;
};

#endif //UPDATEEVENT_H
