/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef TRIGGEREDSOURCE_H
#define TRIGGEREDSOURCE_H

#include "source.h"
#include <qevent.h> 

/**
 * TriggeredSource provides fetchValue and 
 * can be triggered asynchronously by ThreadedTrigger
 * @author Ken Werner
 */
class TriggeredSource : public Source{
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new TriggeredSource
	 */
	TriggeredSource(QWidget* inParent);
	
	virtual ~TriggeredSource();

public slots:

	/**
	 * Returns the formatted value of this source
	 */
	virtual QString getValue() const;

	/**
	 * Fetches and returns the value of this source
	 * This method might be called from a thread so don't call it directly
	 */
	virtual QString fetchValue() = 0;

signals:
	/**
	 * This signal is emitted whenever the value of this source (mValue) is updated
	 */
	void valueUpdated(const QString& inValue);

protected:
    /**
     * consumes the UpdateEvent 
     */
    virtual void customEvent(QCustomEvent* event);
	
	/**
	 * the buffered value of this source
	 */
	QString mValue;
};
#endif //TRIGGEREDSOURCE_H
