/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "labelsource.h"
#include <qlabel.h>
#include <kcolorbutton.h>
#include <kfontrequester.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <klocale.h>

//#include "kdebug.h"

LabelSource::LabelSource(QWidget* inParent):
		TriggeredSource(inParent),
		mParent(inParent),
		mLabelSourcePrefs(NULL){ 
}

LabelSource::~LabelSource(){
}

QWidget* LabelSource::getWidget(){
	//kdDebug() << "LabelSource::getWidget called: " << mID << endl;
	return mLabel;
}

void LabelSource::createSubPrefs(QWidget* inParent){
	if(!mLabelSourcePrefs){
		mLabelSourcePrefs = new LabelSourcePrefs(inParent, "labelsourceprefsui");
		// disable nameCheckBox if taskbarCheckBox is disabled
		connect(mSourcePrefs->taskbarCheckBox, SIGNAL(toggled(bool)), mLabelSourcePrefs->colorLabel, SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, SIGNAL(toggled(bool)), mLabelSourcePrefs->colorButton, SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, SIGNAL(toggled(bool)), mLabelSourcePrefs->fontLabel, SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, SIGNAL(toggled(bool)), mLabelSourcePrefs->fontRequester, SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, SIGNAL(toggled(bool)), mLabelSourcePrefs->alignmentLabel, SLOT(setEnabled(bool)));
		connect(mSourcePrefs->taskbarCheckBox, SIGNAL(toggled(bool)), mLabelSourcePrefs->alignmentComboBox, SLOT(setEnabled(bool)));
		addPrefs(mLabelSourcePrefs);
	}
}

void LabelSource::updatePrefsGUI(){
	TriggeredSource::updatePrefsGUI(); // update prefs of the super class
	mLabelSourcePrefs->colorButton->setColor(mLabel->paletteForegroundColor());
	mLabelSourcePrefs->fontRequester->setFont(mLabel->font());
	switch (mLabel->alignment()) {
		case Qt::AlignCenter:
			mLabelSourcePrefs->alignmentComboBox->setCurrentItem(1);
			break;
		case Qt::AlignRight:
			mLabelSourcePrefs->alignmentComboBox->setCurrentItem(2);
			break;
		default: // Qt::AlignLeft
			break;
			mLabelSourcePrefs->alignmentComboBox->setCurrentItem(0);
	}
}

void LabelSource::setPrefsWidgetsEnabled(bool isEnabled, bool isShownOnApplet){
	TriggeredSource::setPrefsWidgetsEnabled(isEnabled, isShownOnApplet);
	// disable/enable some widgets if source is disabled/enabled	if(isEnabled)
	mLabelSourcePrefs->colorLabel->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->colorButton->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->fontLabel->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->fontRequester->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->alignmentLabel->setEnabled(isEnabled && isShownOnApplet);
	mLabelSourcePrefs->alignmentComboBox->setEnabled(isEnabled && isShownOnApplet);
}

void LabelSource::applyPrefs(){
	TriggeredSource::applyPrefs(); // call apply prefs of the super class
	mLabel->setPaletteForegroundColor(mLabelSourcePrefs->colorButton->color());
	mLabel->setFont(mLabelSourcePrefs->fontRequester->font());
	int alignID = mLabelSourcePrefs->alignmentComboBox->currentItem();
	Qt::AlignmentFlags align = Qt::AlignCenter;
	if(alignID == 0){
		align = Qt::AlignLeft;
	}else if(alignID == 2){
		align = Qt::AlignRight;
	}
	mLabel->setAlignment(align);
	updateLabel(mValue);
}

void LabelSource::savePrefs(KConfig* inKConfig){
	TriggeredSource::savePrefs(inKConfig);
	inKConfig->writeEntry(mID + "_color", mLabelSourcePrefs->colorButton->color());
	inKConfig->writeEntry(mID + "_font", mLabelSourcePrefs->fontRequester->font());
	inKConfig->writeEntry(mID + "_align", mLabel->alignment());
}

void LabelSource::loadPrefs(KConfig* inKConfig){
	TriggeredSource::loadPrefs(inKConfig);
	QColor color = inKConfig->readColorEntry(mID + "_color");
	if(!color.isValid())
		color.setRgb(0,0,0);
	mLabel->setPaletteForegroundColor(color);
	mLabel->setFont(inKConfig->readFontEntry(mID + "_font"));
	mLabel->setAlignment(inKConfig->readNumEntry(mID + "_align"));
}

void LabelSource::updateLabel(const QString& inValue){
	// update the label text
	QString text = (getName().isEmpty() || !showName()) ? inValue : getName() + ": " + inValue;
	//kdDebug() << "updateLabel " << getName() << ", value: " << text << endl;
	//if(mLabel->text() != text)
	mLabel->setText(text);
}

void LabelSource::realizeWidget(){
	Source::realizeWidget();
	// the prefs dialog is created in the addPrefs method
	mLabel = new QLabel(i18n("n/a"), mParent);
    mLabel->setTextFormat(Qt::PlainText);
	connect(this, SIGNAL(valueUpdated(const QString&)), this, SLOT(updateLabel(const QString&)));
}
