/***************************************************************************
 *   Copyright (C) 2006 by                                                 *
 *   Flavio Castelli, micron@madlab.it                                     *
 *   Ken Werner, ken.werner@web.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "ibookg4thermalsrc.h"
#include <qtextstream.h> 
#include <klocale.h>

IbookG4ThermalSrc::IbookG4ThermalSrc(QWidget* inParent, const QFile& inSourceFile, const QString& inName):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = inName;
	mName = mID;
	mDescription = i18n("This source shows a thermal sensor of your iBook.");
}

IbookG4ThermalSrc::~IbookG4ThermalSrc(){
}

std::list<Source*>IbookG4ThermalSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QFile ibookCPUFile("/sys/devices/temperatures/sensor1_temperature");
	if(ibookCPUFile.open(IO_ReadOnly)){
		list.push_back(new IbookG4ThermalSrc(inParent, ibookCPUFile, QString("CPU")));
		ibookCPUFile.close();
	}
	QFile ibookGPUFile("/sys/devices/temperatures/sensor2_temperature");
	if(ibookGPUFile.open(IO_ReadOnly)){
		list.push_back(new IbookG4ThermalSrc(inParent, ibookGPUFile, QString("GPU")));
		ibookGPUFile.close();
	}
	return list;
}

QString IbookG4ThermalSrc::fetchValue(){
	QString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		QTextStream textStream( &mSourceFile );
		s = textStream.readLine().stripWhiteSpace();
		mSourceFile.close();
		s= formatTemperature(s);
    }
	return s;
}

