/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef IBMHDAPSSRC_H
#define IBMHDAPSSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <qfile.h>
#include <list>

/**
 * IBMHDAPSSrc reads temperature values of the IBM Hard Drive Active Protection System (HDAPS)
 * from /sys/bus/platform/drivers/hdaps/hdaps/temp1 
 * which is provided by the hdapds.ko kernel module.
 * @author Ken Werner
 */
class IBMHDAPSSrc : public LabelSource {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File
	 */
	IBMHDAPSSrc(QWidget* inParent, const QFile& inSourceFile);
	virtual ~IBMHDAPSSrc();

	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(QWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual QString fetchValue();

private:
	/**
	 * The file from which the value is read
	 */
	QFile mSourceFile;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //IBMHDAPSSRC_H
