/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "ibmacpithermalsrc.h"
#include <qtextstream.h> 
#include <qfile.h>
#include <klocale.h>
//#include "hal/libhal.h" 
// hal-get-property --udi /org/freedesktop/Hal/devices/computer --key system.product

IBMACPIThermalSrc::IBMACPIThermalSrc(QWidget* inParent, const QFile& inSourceFile, unsigned int inIndex):
		LabelSource(inParent),
		mIndex(inIndex),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	//mName = mName.setNum(inIndex+1).prepend("IBM");
	mID = IBMACPIThermalSrc::index2Name(inIndex);
	mName = mID;
	mDescription = i18n("This source is provided by the ACPI driver for IBM ThinkPads.");
}

IBMACPIThermalSrc::~IBMACPIThermalSrc(){
}

std::list<Source*>IBMACPIThermalSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QFile ibmFile( "/proc/acpi/ibm/thermal" );
	if(ibmFile.open(IO_ReadOnly)){
		QTextStream textStream( &ibmFile );
		QString s = textStream.readLine();
		ibmFile.close();
		s = s.remove("temperatures:");
		QStringList entries = QStringList::split(' ' ,s);
		for ( unsigned int i = 0; i < entries.size(); i++ ){
			if(!entries[i].startsWith("-") && !entries[i].startsWith("0"))
				list.push_back(new IBMACPIThermalSrc(inParent, ibmFile, i));	
		}
	}
	return list;
}

QString IBMACPIThermalSrc::fetchValue(){
	QString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		QTextStream textStream( &mSourceFile );
		s = textStream.readLine();
		mSourceFile.close();
		s = s.section(':', 1, 1).section(' ', mIndex, mIndex, QString::SectionSkipEmpty).stripWhiteSpace();
		s = formatTemperature(s);	
	}
	return s;
}

QString IBMACPIThermalSrc::index2Name(unsigned int inIndex){
	switch(inIndex){
	case 0:
		return "CPU";
	case 1:
		return "MiniPCI";
	case 2:
		return "HDD";
	case 3:
		return "GPU";
	case 4:
		return "Battery1";
	case 6:
		return "Battery2";
	default:
		return "ibmacpi" + QString().setNum(inIndex);
	}
}
