/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "hddtempsrc.h"

#include <qsocketdevice.h>
#include <qhostaddress.h>
#include <qcstring.h> 

#include <klocale.h>

//#include <kdebug.h>

const Q_ULONG HDDTempSrc::BUFFERSIZE = 128;
const Q_UINT32 HDDTempSrc::ADDRESS = (127<<24)|1;
const Q_UINT16 HDDTempSrc::PORT = 7634;

HDDTempSrc::HDDTempSrc(QWidget* inParent, uint inIndex, const QString& inDevice, const QString& inModelName):
		LabelSource(inParent),
		mIndex(inIndex),
		mTrigger(this){
	mID = "HDDTemp" + QString().setNum(inIndex);
	mName = mID;
	mDescription = i18n("This source is provided by hddtemp. (%1, %2)").arg(inDevice).arg(inModelName);
}

HDDTempSrc::~HDDTempSrc(){
}

std::list<Source*>HDDTempSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QSocketDevice sd;
	sd.setBlocking(true);
	if(sd.connect((ADDRESS), PORT)){
		//kdDebug() << "hddtemp is availalble" << endl;
		QCString tmp(0);
		Q_LONG numBytes = 0;
		Q_LONG numTotalBytes = 0;
		do{
			tmp.resize(numTotalBytes+BUFFERSIZE);
			numBytes = sd.readBlock(tmp.data()+numTotalBytes, BUFFERSIZE);
            // numBytes could be -1 too in case of an error!
			numTotalBytes += QMAX(numBytes, 0);
		}while(numBytes>0);
		sd.close();
		tmp.resize(numTotalBytes+1);	
		//kdDebug() << "following data was read: " << tmp << endl;
		// split the string
		QStringList sl = QStringList::split(tmp[0], tmp);
		// create the sources
		if(sl.size() > 0 && sl.size()%4 == 0){
			for(uint i = 0; i < sl.size(); i += 4)
				list.push_back(new HDDTempSrc(inParent, i/4, sl[i], sl[i+1]));
		}
	}//else
		//kdDebug() << "hddtemp is not availalble" << endl; // << sd.error() << endl;
	return list;
}

QString HDDTempSrc::fetchValue(){
	QString s = "n/a";
	QSocketDevice sd;
	sd.setBlocking(true);
	if(sd.connect((ADDRESS), PORT)){
		QCString tmp(0);
		Q_LONG numBytes = 0;
		Q_LONG numTotalBytes = 0;
		do{
			tmp.resize(numTotalBytes+BUFFERSIZE);
			numBytes = sd.readBlock(tmp.data()+numTotalBytes, BUFFERSIZE);
            // numBytes could be -1 too in case of an error!
			numTotalBytes += QMAX(numBytes, 0);
		}while(numBytes>0);
		sd.close();
		tmp.resize(numTotalBytes+1);
		QStringList sl = QStringList::split(tmp[0], tmp);
		if(sl.size() > 0 && sl.size()%4 == 0){
			s = formatTemperature(sl[mIndex*4+2]);
		}
	}
	return s;
}

