/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "sourcelistitem.h"
#include <qcheckbox.h> 

//#include <kdebug.h>

SourceListItem::SourceListItem(Source* inSource, QCheckListItem* inParent, Type tt):
		QCheckListItem(inParent, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QCheckListItem* inParent, QListViewItem* after, Type tt):
		QCheckListItem(inParent, after, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QListViewItem* inParent, Type tt):
		QCheckListItem(inParent, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QListViewItem* inParent, QListViewItem* after, Type tt):
		QCheckListItem(inParent, after, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QListView* inParent, Type tt):
		QCheckListItem(inParent, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QListView* inParent, QListViewItem* after, Type tt):
		QCheckListItem(inParent, after, inSource->getName(), tt){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QListViewItem* inParent, const QPixmap& p):
		QCheckListItem(inParent, inSource->getName(), p){
	mSource = inSource;
	initItem();
}
SourceListItem::SourceListItem(Source* inSource, QListView* inParent, const QPixmap& p):
		QCheckListItem(inParent, inSource->getName(), p){
	mSource = inSource;
	initItem();
}

SourceListItem::~SourceListItem(){
}

void SourceListItem::initItem(){
	//setText(1, mSource->getName());
	//item->setText(2, source->getDescription());

	connect(mSource, SIGNAL(enabledChanged(bool, Source*)), this, SLOT(setEnabled(bool)));
	setOn(mSource->isEnabled());
}

void SourceListItem::updateText() {
    setText(0, mSource->getName());
}

Source* SourceListItem::getSource(){
	return mSource;
}

void SourceListItem::setName(const QString& inName){
	setText(1, inName);
}

void SourceListItem::setEnabled(bool inEnabled){
	mSource->setMaybeEnabled(inEnabled);
}

void SourceListItem::stateChange(bool inOn){
	QCheckListItem::stateChange(inOn);
	setEnabled(inOn);
}
