/***************************************************************************
 *   Copyright (C) 2006 by Valentine Sinitsyn                              *
 *   e_val@inbox.ru                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef CPUFREQDPROFILE_H
#define CPUFREQDPROFILE_H

#include <qstring.h>

class CPUFreqdProfile {
	public:
		CPUFreqdProfile() {};
		CPUFreqdProfile(QString & descr);
		virtual ~CPUFreqdProfile();

		bool isValid() const;	

		bool active() const;
		const QString & name() const;
		int minfreq() const;
		int maxfreq() const;
		const QString & policy() const;

	private:
		int m_active;
		QString m_name;
		int m_id;
		int m_minfreq;
		int m_maxfreq;
		QString m_policy;
};

#endif
