/*
 * main.cpp
 *
 * Copyright (c) 2007 Fabian Wuertz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "install.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>


static KCmdLineOptions options[] =
{
	{ "+[URL]",   I18N_NOOP("Location to open"), 0 },
	KCmdLineLastOption
};




int main(int argc, char **argv)
{
	// specify data for About dialog
	KAboutData* about = new KAboutData("kdpkg-install", I18N_NOOP("kdpkg-install"), "");

	about->setProgramLogo( QImage("/usr/share/icons/hicolor/32x32/apps/kdpkg.png") );
	about->setShortDescription( I18N_NOOP("Frontend for dpkg.") );
	about->setLicense(KAboutData::License_GPL_V2);
   about->setHomepage("http://trinity.pearsoncomputing.net");
   about->setBugAddress("http://bugs.pearsoncomputing.net");
	about->setCopyrightStatement("(c) 2010 Timothy Pearson\n(c) 2007 Fabian Würtz");

	about->addAuthor("Timothy Pearson (Trinity Project)", I18N_NOOP("Developer"), "kb9vqf@pearsoncomputing.net", "http://trinity.pearsoncomputing.net");
	about->addAuthor("Fabian Würtz (xadras)", I18N_NOOP("Developer"), "xadras@sidux.com", "http://linux.wuertz.org/");



	KCmdLineArgs::init(argc, argv, about);
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication app;
	install *mainWin = 0;

	if (!app.isRestored())
	{
		// no session.. just start up normally
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		QString url;
		
		for(int i = 0; i < args->count(); i++) // Counting start at 0!
			url = QString::fromLocal8Bit(args->arg(i));

		//printf(url);

		mainWin = new install( url );
		app.setMainWidget( mainWin );
		//mainWin->getFile(url);
		mainWin->show();

		args->clear();
	}

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	return app.exec();
}

