/*
 * kdpg.h
 *
 * Copyright (c) 2007 Fabian Wuertz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INSTALL_H_
#define INSTALL_H_

#include <installdialog.h>

#include <kde_terminal_interface.h>
#include <kparts/part.h>
#include <process.h>
#include <qprocess.h>

class install : public InstallDialog
{
	Q_OBJECT

	public:
		install(const QString &url = QString(), QWidget *parent = 0L, const char *name = 0L, const QStringList &foo = QStringList());
		QString installPkg;
		QString removePkg;
		QString path;
		QStringList fields;
		QString m_kdePrefix;
		bool isInstalled(QString);
		bool checkArchitecture();
		bool isLocked();
		QStringList getVersions(QString);



	private:
		Process* shell;


	public slots:
		virtual void showAbout();
		virtual void page1();
		virtual void page2x1();
		virtual void page2x2();
		virtual void page3();
		virtual void page4();
		virtual void page5();
		virtual void showDependencies();
		virtual void next1();
		virtual void next2();

	signals:
		void exit(bool);

};

#endif
