/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef WATOOLS_H
#define WATOOLS_H

//maximum number of packets send without any received. When it's exceeded, the connection is considered lost. 
#define WA_TX_THRESHOLD 14

#include <iwlib.h>
#include <time.h>
class QStringList;

class WATools
{
public:
        static inline void setInterface( const char* new_ifname ) //sets default (fallback) interface
        {
                ifname = (char*)new_ifname;
        }
        static inline char* interface() //returns default (fallback) interface
        {
                return ifname;
        }
        // general interface functions
	static bool isUp( const char* _ifname = 0 ); //returns current STATUS
	static bool setUp( bool u, const char* _ifname = 0 ); //bring interface up/down
	static char* ip( const char* _ifname = 0 ); //returns current IP
	static int txpackets( const char* _ifname = 0 ); //returns number of packets send via _iface
	static int rxpackets( const char* _ifname = 0 ); //returns number of packets received via _iface
	
	// wireless extensions calls
	static bool isWireless( const char* _ifname ); //returns true if iface is a valid wireless interface
	static char* essid( const char* _ifname = 0 ); //returns current ESSID
	static char* ap( const char* _ifname = 0 ); //returns current AP
        static int quality( const char* _ifname = 0 ); //returns current QUALITY
        static int txpower( const char* _ifname = 0 ); //returns current TXPOWER

	static bool hasKey( const char* _ifname = 0 ); //returns true if WEP key for the specified interface is set

	static int availableNetworks( const char* _ifname = 0 ); //returns a list of available networks

	// misc functions
	static bool isConnected( const char* _ifname = 0 ); //returns true if the interface is properly CONFIGURED AND ASSOCIATED
	static char* kernelModule( const char* _ifname = 0 ); //returns KERNEL MODULE name for the given interface
	static void cleanup(); //closes open socket etc.

private:
        static char* ifname;
	static int iw_socket;
	static int prev_tx_packets, prev_rx_packets;

	static int getStatistic( const char* statName, const char* _ifname = 0 );
	static int doRequest( int request, struct ifreq* reqStruct, const char* _ifname = 0 );
	static int doWirelessRequest( int request, struct iwreq* reqStruct, const char* _ifname = 0 );
	static int doWirelessStatisticsRequest( iw_statistics* iwStats, const char* _ifname = 0 );
};

#endif //WATOOLS_H
