/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "ui_netparamswizard.h"
#include "netparams.h"

#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>

#include <kiconloader.h>

ui_NetParamsWizard::ui_NetParamsWizard(QWidget* parent, const char* name, bool modal, WFlags fl)
                : NetParamsWizard(parent,name, modal,fl)
{
        backButton()->setIconSet( SmallIconSet("back") );
        nextButton()->setIconSet( SmallIconSet("forward") );
        cancelButton()->setIconSet( SmallIconSet("cancel") );
        finishButton()->setIconSet( SmallIconSet("ok") );
        //helpButton()->setIconSet( SmallIconSet("help") );
        helpButton()->hide();
        setFinishEnabled( page( pageCount()-1 ), true );
}

ui_NetParamsWizard::~ui_NetParamsWizard()
{}

/*$SPECIALIZATION$*/

void ui_NetParamsWizard::setWepEnabled( bool w )
{
        setAppropriate( page(4), w );
}

void ui_NetParamsWizard::setWpaEnabled( bool w, QStringList settings )
{
        setAppropriate( page(5), w );
	if (w) labelWpaSettings->setText( QString("<i>%1</i>").arg( settings.join("<br>") ) );
}


void ui_NetParamsWizard::setEssidEnabled( bool e )
{
        setAppropriate( page(1), e );
}

void ui_NetParamsWizard::next()
{
        if (indexOf(currentPage())==2)
                setAppropriate( page(3), radioManualConfig->isChecked() );
        QWizard::next();
}

WANetParams ui_NetParamsWizard::readNetParams( WANetParams & np )
{
        if (appropriate(page(1)))
                np.essid = essid->text();
        np.dhcp = radioDhcp->isChecked();
        if (!np.dhcp) { // manual configuration option selected
                np.ip = ip->text();
                np.broadcast = broadcast->text();
                np.netmask = netmask->text();
                np.gateway = gateway->text();
                np.domain = domain->text();
                np.dns1 = dns1->text();
                np.dns2 = dns2->text();
        }
        if (np.wep) { // WEP authentication needed
                if (radioWepOpen->isChecked())
                        np.wepMode = "open";
                else
                        np.wepMode = "restricted";
                np.wepKey = wepKey->text();
                if (checkWepAscii->isChecked())
                        np.wepKey.prepend("s:");
        }
        if (np.wpa) { // WPA authentication needed
                np.wpaKey = wpaKey->text();
                if (checkWpaAscii->isChecked())
                        np.wpaKey.prepend("s:");
        }

        return np;
}

#include "ui_netparamswizard.moc"

