/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "ui_netparamsedit.h"
#include "netparams.h"

#include <qgroupbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

#include <kiconloader.h>

ui_NetParamsEdit::ui_NetParamsEdit(QWidget* parent, const char* name, bool modal, WFlags fl)
                : netProperties(parent,name, modal,fl)
{
        buttonHelp->hide();
        buttonOk->setIconSet( SmallIconSet("ok") );
        buttonCancel->setIconSet( SmallIconSet("cancel") );
}

ui_NetParamsEdit::~ui_NetParamsEdit()
{}

/*$SPECIALIZATION$*/

/*void ui_NetParamsEdit::setWepEnabled( bool w )
{
	tabSecurity->setShown(w);
}*/

/*void ui_NetParamsEdit::setEssidEnabled( bool e )
{
	boxEssid->setShown(e);
}*/

void ui_NetParamsEdit::setValues( const WANetParams & np )
{
        boxEssid->setShown(np.hiddenEssid);
        essid->setText(np.essid);

        tabNetParams->setTabEnabled( tabSecurity, (np.wep || np.wpa) );
	
	if ( tabSecurity->isEnabled() ) {
		groupWep->setEnabled( np.wep );
		groupWpa->setEnabled( np.wpa );
		if (np.wep) {
        		if (np.wepMode=="open")
                		radioWepOpen->setChecked(1);
        		else
                		radioWepRestricted->setChecked(1);
        		if ( np.wepKey.left(2)=="s:" ) { //ASCII key
                		checkWepAscii->setChecked(true);
                		wepKey->setText( np.wepKey.right(np.wepKey.length()-2) );
        		} else { //HEX key
                		checkWepAscii->setChecked(false);
                		wepKey->setText( np.wepKey );
			}
        	}
		if (np.wpa) {
			labelWpaSettings->setText( QString("<i>%1</i>").arg( np.wpaSettings.join("<br>") ) );
        		if ( np.wpaKey.left(2)=="s:" ) { //ASCII key
                		checkWpaAscii->setChecked(true);
                		wpaKey->setText( np.wpaKey.right(np.wpaKey.length()-2) );
        		} else { //HEX key
                		checkWpaAscii->setChecked(false);
                		wpaKey->setText( np.wpaKey );
			}
		}
	}

        radioDhcp->setChecked( np.dhcp );
        radioManualConfig->setChecked( !np.dhcp );

        ip->setText(np.ip);
        broadcast->setText( np.broadcast );
        netmask->setText( np.netmask );
        gateway->setText( np.gateway );
        domain->setText( np.domain );
        dns1->setText( np.dns1 );
        dns2->setText( np.dns2 );

	preConnectionCommand->setText( np.preConnectionCommand );
	preConnectionDetached->setChecked( np.preConnectionDetached );
	preConnectionTimeout->setValue( np.preConnectionTimeout );

	postConnectionCommand->setText( np.postConnectionCommand );
	postConnectionDetached->setChecked( np.postConnectionDetached );
	postConnectionTimeout->setValue( np.postConnectionTimeout );

	preDisconnectionCommand->setText( np.preDisconnectionCommand );
	preDisconnectionDetached->setChecked( np.preDisconnectionDetached );
	preDisconnectionTimeout->setValue( np.preDisconnectionTimeout );

	postDisconnectionCommand->setText( np.postDisconnectionCommand );
	postDisconnectionDetached->setChecked( np.postDisconnectionDetached );
	postDisconnectionTimeout->setValue( np.postDisconnectionTimeout );
}

WANetParams ui_NetParamsEdit::readNetParams( WANetParams & np )
{
        if (np.hiddenEssid) {
                np.wasHiddenEssid = true;
                np.essid = essid->text();
        }
        np.dhcp = radioDhcp->isChecked();
        np.ip = ip->text();
        np.broadcast = broadcast->text();
        np.netmask = netmask->text();
        np.gateway = gateway->text();
        np.domain = domain->text();
        np.dns1 = dns1->text();
        np.dns2 = dns2->text();
        if (np.wep) { // WEP authentication needed
                np.wasWep = true;
                if (radioWepOpen->isChecked())
                        np.wepMode = "open";
                else
                        np.wepMode = "restricted";
                np.wepKey = wepKey->text();
                if (checkWepAscii->isChecked())
                        np.wepKey.prepend("s:");
        }
        if (np.wpa) { // WPA authentication needed
                np.wpaKey = wpaKey->text();
                if (checkWpaAscii->isChecked())
                        np.wpaKey.prepend("s:");
        }


	np.preConnectionCommand = preConnectionCommand->text();
	np.preConnectionTimeout = preConnectionTimeout->value();
	np.preConnectionDetached = preConnectionDetached->isChecked();

	np.postConnectionCommand = postConnectionCommand->text();
	np.postConnectionTimeout = postConnectionTimeout->value();
	np.postConnectionDetached = postConnectionDetached->isChecked();

	np.preDisconnectionCommand = preDisconnectionCommand->text();
	np.preDisconnectionTimeout = preDisconnectionTimeout->value();
	np.preDisconnectionDetached = preDisconnectionDetached->isChecked();

	np.postDisconnectionCommand = postDisconnectionCommand->text();
	np.postDisconnectionTimeout = postDisconnectionTimeout->value();
	np.postDisconnectionDetached = postDisconnectionDetached->isChecked();

        return np;
}

#include "ui_netparamsedit.moc"

