/***************************************************************************
 *   Copyright (C) 2007 by Daniel Prynych   *
 *   Daniel.Prynych@buzuluk.cz   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KNUTANALOG_H
#define KNUTANALOG_H

#include <qframe.h>

#include <qpixmap.h>  // po odladeni smazat
#include <qimage.h>
#include <qmutex.h>


class QPainter;
class QFont;

enum speedOfAAlias { none,fast,slow};


/**
 * This class shows analog measuring panels
 *
 * @author Daniel Prynych
 * @short analog measuring panels
 * @version 0.1
*/

class KNutAnalog : public QFrame  {
  Q_OBJECT
public:


  struct extentOfDyeDef {
    double start,end;
    int color;
    };



/**
 * Construct - makes object for analog measuring panel about size 130 x 130 points
 * Konstruktor - vytvori objekt pro analogovy merici panel o rozmerech 130 x 130 bodu
 *
 * When you need paint or repainr panel you have to call functiin reapaint
 * other functions calls this function theirself, when run = true
 * Pokud je potreba vykreslit nebo prekreslit panel je nutno zavolat funkci repaint,
 * ostatni funkce ji zavolaji sami pokud je run = TRUE.
 *
 * @param bottomLimit Is bottom value of scale..
 * @param topLimit is end value of scale.
 * @param typeOfView determine type view of scale 1- circle 2- right part of circle, 3 - top part of circle
 * @param countOfParts determine count of big parts (parents parts) of scale.
 * @param countOfSubParts determine count small parts (children parts) id scale, evere big part include e few small part.
 * @param pointerColor  determine color of pointer.
 * @param scaleColor determine color of scale.
 * @param textColor determine color of  text.
 * @param analogFonts determine fonts for text and scale.
 * @param qualityOfPainter determine  quality painting of pointer- 0 nothing. 1 fast antialiasing, 2 slow antialiasing, 3 blur motion + fast antialiasing, 4 blur motion + slow antialiasing 
 * @since  0.3
 **/
  KNutAnalog(QWidget *parent = 0, const char *name = 0, int Astart = 0, int topLimit = 100, int typeOfView = 1, int countOfParts = 5, int countOfSubParts = 0, QColor pointerColor = Qt::black, QColor m_scaleColor = Qt::black, QColor textColor = Qt::black, QFont *analogFonts = 0, int qualityOfPointer = 4, bool makeBG = false );

/**
 * Destruktor
 * @since  0.1
 **/
    ~KNutAnalog();


/**
 * Sets text for top and bottom text of panel.
 * Nastavi text dolni a horni text na panelu.
 *
 * @param  m_inscription  determinuje inscription , bottom text , usually.
 * @param  m_inscription Udava nadpis, "dolni" text, obvykle co je mereno.
 * @param text_up Udava mernou jednotku "horni" text, obvykle merna jednotka.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 **/
  void setText (QString m_inscription, QString text_up, bool run=false);


/**
 * Makes background of analog panel.
 * Vytvori pozadi analogoveho panelu.
 *
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite  prekresleni panelu.
 *
 * @since  0.2
 **/
  void makeBackground (bool run=false);


/**
 * Repaint pointer of analog panel.
 * Prekresli rucicku analogoveho panelu.
 *
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite  prekresleni panelu.
 *
 * @since  0.2
 **/
  void repaintPointer ( bool run );



/**
 * Nastavuje devet zakladnich barev pro mezikruzi.
 * Sets nine basic color for circle in scale
 *
 * @param run = TRUE provede okamzite prekresleni panelu.
 * @param run = TRUE makes immediately repaint of panel 
 *
 * @since  0.1
 **/
  void setDefaultArcColor(bool run=false);


/**
 * Nastavi zakladni barvu pro mezikruzi.
 * Sets basic color for circle in scale
 *
 * @param reg Poradove cislo barvy (barevneho registru).
 * @param color Barva na kterou bude nastaven registr barvy.
 *
 * @since  0.1
 **/
  void setArcColor(int reg, QColor color );



/**
 * Vybarvi cast stupnice zadanou barvou.
 * Nastavi rozsah mezikruzi, podle stupnice od pocatecni hodnoty do koncove hodnoty stupnice
 * Barevne casti se barvy postupne, podel poradoveho cisla, mohou se prekryvat.
 * Je mozno nastavit jen 5 casti !!
 *
 * @param startOfCircle Urcuje zazatek mezikruzi.
 * @param endOfCircle Urcuje konec mezikruzi.
 * @param color Urcuje barvu.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.2
 **/
  void addArc (double startOfCircle, double endOfCircle, int regColor, bool run=false);



/**
 * Clear colors of scale
 * Zrusi vybarveni stupnice.
 *
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 **/
  void delArc (bool run=false);



/**
 *
 * Nastavi rozsah stupnice.
 *
 * @param Astart Urcuje pocatecni hodnotu stupnice.
 * @param AEND Urcuje koncovou hodnotu stupnice.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.2
 */
  void setRange (int Astart = 0, int Aend = 100, bool run=false);

/**
 * Sets number of parts od scale
 * Nastavi pocet dilku stupnice.
 *
 * @param Count Determine number of parts of pointer..
 * @param Count Urcuje pocet casti stupnice.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setMember (int Count, bool run=false);

/**
 * Sets color of analog pointer.
 * Nastavi barvu analogove rucicky.
 *
 * @param pointerColor determine color of pointer.
 * @param pointerColor Urcuje barvu rucicky.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 * @since  0.2
 */
  void setPointerColor (QColor pointerColor, bool run=false);

/**
 * sets color of text;
 * Nastavi barvu textu.
 *
 * @param fontColor determine color of font.
 * @param fontColor urcuje barvu fontu.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setFontColor (QColor fontColor,  bool run=false );



/**
 * Sets color of scale
 * Nastavi barvu stupnice.
 *
 * @param scaleColor determine color if scale.
 * @param scaleColor urcuje barvu stupnice.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setScaleColor (QColor scaleColor, bool run=false);


/**
 * Sets type of digital processing of pointer. 0 nothing. 1 fast antialiasing, 2 slow antialiasing, 3 blur motion + fast antialiasing, 4 blur motion + slow antialiasing.
 *
 * @param qualityOfPointer determine quality of pointer's digital procesing
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setDigitalProcesing (int qualityOfPointer, bool run =false );



/**
 * Sets pointer on value pointerValue.
 * Posune rucicku na hodnotu pointerValue.
 *
 * @param pointerValue Urcuje hodnotu na jakou bude nastavena rucicka.
 * @param run = TRUE makes immediately repaint of panel 
 * @param run = TRUE provede okamzite prekresleni panelu.
 *
 * @since  0.1
 */
  void setPointer (double pointerValue,  bool run=true );


/**
 * Const. determines width of analog panel in points
 * Konstanta, udava velikost analogoveho panelu v bodech.
 *
 * @since  0.1
 */
  static const int AnalogWidth = 130;


  public slots:

/**
 * Sets font of scale, change is doing immediately
 * Nastavi font stupnice, zmena je provedena okamzite.
 *
 * @param newScaleFont Urcuje novy font hodnot stupnice.
 * @param newScaleFont Urcuje novy font hodnot stupnice.
 *
 * @since  0.1
 */
  void slotSetScaleFont(QFont newScaleFont);


/**
 * Sets font of text. change is doing immediately.
 * Nastavi font textu, zmena je provedena okamzite.
 *
 * @param newTextFont Urcuje novy font pro texty.
 *
 * @since  0.1
 */
  void slotSetTextFont(QFont newTextFont);


/**
 * Nastavi font stupnice a textu, zmena je provedena okamzite.
 *
 * @param newTextFont Urcuje novy font pro texty a hodnoty stupnice.
 *
 * @since  0.1
 */
  void slotSetAllFont(QFont newAllFont);


/**
 * Repaint layer of backgroud and layer of pointer,
 * all panel will be repainted
 * Da povel k prekreseni urovne pozadi a  urovne rucicky.
 * To znamena, ze bude prekreslen kompletne cely panel.
 *
 * @since  0.1
 */
  void repaintAll (void);


  protected:
  virtual void resizeEvent( QResizeEvent * );
  virtual void paintEvent( QPaintEvent * );

  private:


/**
 * @internal
 */
  void paintBackGround ( void );


/**
 * @internal
 */
  void paintPointer ( void );


/**
 * @internal
 */
  void paintPointerSlowly ( double position, int centerX , int centerY, int widthOfCircle);

/**
 * @internal
 */
  void paintPointerFastly (  double position);


/**
 * @internal
 */
  void paintPartOfCircle ( QPainter *paint, int centerX , int centerY, int widthOfCircle );


/**
 * @internal
 */
  void paintScale ( QPainter *paint , int centerX , int centerY, int widthOfCircle);


/**
 * @internal
 */
  void makeAntialiasing (QImage* myImage, QPixmap* smallPixmap, const QRgb colorOfBG, speedOfAAlias speed = slow , int typeOfView = 0);


/**
 * @internal
 */
  void makeMotionBlur (QImage* myImage, const QRgb colorOfBG, int typeOfView = 0);


/**
 * @internal
 */
  void paintScaleNumbers ( QPainter *paint );

/**
 * @internal
 */
  void paintText ( QPainter *paint );


/**
 * @internal
 */
  void paintValueOfPointer ( QPainter *p, double value);



  static const int m_widthOfBackGround = 122;
  static const int m_startOfBackGround = 4;

  bool m_showBackGround;
  bool m_showPointer;

  int m_bottomLimit;
  int m_topLimit;
  int m_typeOfView;   // udava typ meraku
  int m_countOfParts; // pocet policek na stupnici
  int m_countOfSubParts; // pocet dilku v policku na stupnici
  QColor m_pointerColor, m_scaleColor, m_textColor; // colors of pointer, text and scale

  QColor m_arcColors[9];
  QString m_inscription;
  QString AnMJ;
  int m_countOfColorParts; // count of color parts on scale
  double m_valueOfPointer; //  position of pointer;
  double m_angleOfViewer, m_startAngle; //pocatecni_uhel;
  int m_centerX;
  int m_centerY;
  int m_direction;
  int m_widthOfScale;
  int m_radiusOfScaleNumbers;


  speedOfAAlias m_speedOfAAlias;
  bool m_makeBlurMotion;

  QFont m_scaleFont;
  QFont m_textFont;

  QPixmap *m_wholeLayer;

  QPixmap *m_backgroudLayerBig;


  QPixmap *m_scaleLayerBig;
  QPixmap *m_scaleLayerSmall;

  QPixmap *m_pointerLayerBig;
  QPixmap *m_pointerLayerSmall;


  extentOfDyeDef m_extentOfDye[5];

  QMutex m_pointerMutex;
};


#endif
