/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruleoptionedittos.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditortos.h"

namespace KMF {
KMFRuleOptionEditTos::KMFRuleOptionEditTos(QObject *parent, const char *name)
		: KMFRuleOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleOptionEditTos::KMFRuleOptionEditTos(QObject *parent, const char *name)" << endl;
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorTos( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}

KMFRuleOptionEditTos::~KMFRuleOptionEditTos() {}


void KMFRuleOptionEditTos::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleOptionEditTos::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}


const QString& KMFRuleOptionEditTos::optionEditName() const {
	return *( new QString( i18n("Tos Option") ) );
}
const QString& KMFRuleOptionEditTos::description() const {
	return *( new QString( i18n("This plugin manages the Tos options of iptables.") ) );
}

void KMFRuleOptionEditTos::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleOptionEditTos::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleOptionEditTos::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleOptionEditTos::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}





// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleOptionEditTosFactory::s_instance = 0L;
// KAboutData* KMFRuleOptionEditTosFactory::s_about = 0L;

KMFRuleOptionEditTosFactory::KMFRuleOptionEditTosFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleOptionEditTosFactory" );
}

QObject* KMFRuleOptionEditTosFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleOptionEditTos( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleOptionEditTosFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleOptionEditTosFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruleoptionedit_tos() {
		return new KMFRuleOptionEditTosFactory;
	}
}

}


#include "kmfruleoptionedittos.moc"
