//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfaceicmp.h"

// QT includes
#include <qstring.h>
#include <qcheckbox.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>

// Project includes
#include "../core/kmfnetwork.h"
#include "../core/kmfgenericdoc.h"

namespace KMF {
KMFGenericInterfaceIcmp::KMFGenericInterfaceIcmp( QWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceIcmp( parent, name, f ) {
connect( c_allow_ping, SIGNAL( toggled( bool ) ),
	this, SLOT( slotEnablePingReplyToggled( bool ) ) );
connect( c_limit_ping, SIGNAL( toggled( bool ) ),
	this, SLOT( slotEnablePingReplyLimitToggled( bool ) ) );
}


KMFGenericInterfaceIcmp::~KMFGenericInterfaceIcmp() {}

void KMFGenericInterfaceIcmp::slotUpdateView( NetfilterObject* ) {
	kdDebug() << "KMFGenericInterfaceIcmp::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	slotUpdateView();
}

void KMFGenericInterfaceIcmp::slotUpdateView() {
	kdDebug() << "KMFGenericInterfaceIcmp::slotUpdateView()" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	c_allow_ping->setChecked( m_doc->currentDocAsGenericDoc()->allowPingReply() );
	c_limit_ping->setChecked( m_doc->currentDocAsGenericDoc()->limitPingReply() );

}
void KMFGenericInterfaceIcmp::loadDoc( KMFNetwork* doc ) {
	kdDebug() << "void KMFGenericInterfaceIcmp::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	slotUpdateView();
}

void KMFGenericInterfaceIcmp::slotEnablePingReplyToggled( bool onoff ) {
	kdDebug() << "KMFGenericInterfaceIcmp::slotEnablePingReplyToggled( bool onoff )" << endl;
	if ( m_doc->currentDocAsGenericDoc()->allowPingReply() == onoff ) {
		return;
	}
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "%1 ping reply." ).arg( onoff ? i18n( "Allow" ) : i18n( "Supress" ) )
	);
	if ( onoff ) {
		m_doc->currentDocAsGenericDoc()->setAllowPingReply( onoff );
		if ( c_limit_ping->isChecked() ) {
			m_doc->currentDocAsGenericDoc()->setLimitPingReply( onoff );
		}
	} else {
		m_doc->currentDocAsGenericDoc()->setAllowPingReply( onoff );
	}
	KMFUndoEngine::instance()->endTransaction();
}

void KMFGenericInterfaceIcmp::slotEnablePingReplyLimitToggled( bool onoff ) {
	kdDebug() << "KMFGenericInterfaceIcmp::slotEnablePingReplyLimitToggled( bool onoff )" << endl;
	if ( m_doc->currentDocAsGenericDoc()->limitPingReply() == onoff ) {
		return;
	}
	
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "%1 limit ping reply." ).arg( onoff ? i18n( "Enable") : i18n( "Disable" ) )
	);
	m_doc->currentDocAsGenericDoc()->setLimitPingReply( onoff );
	KMFUndoEngine::instance()->endTransaction();
}

}

#include "kmfgenericinterfaceicmp.moc"
