/***************************************************************************
 *   Copyright (C) 2005 by Christian Hubinger   *
 *   e9806056@student.tuwien.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef KMFSYSTRAY_H
#define KMFSYSTRAY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qstring.h>
#include <qpixmap.h>

// KDE Includes
#include <kpanelapplet.h>
#include <ksystemtray.h>
#include <kconfig.h>
#include <dcopobject.h>

class KAboutData;
class KMFIPTDoc;

class KMFSysTray : public KSystemTray, public DCOPObject
{
    Q_OBJECT

public:
    KMFSysTray( QWidget * );
    virtual ~KMFSysTray();
    virtual int widthForHeight(int height) const;
    virtual int heightForWidth(int width) const;
    virtual void about();
    virtual void help();
    virtual void preferences();
 
public slots:
	void slotSetRunningStatus( bool on );
	void slotLaunchKMF();
	void slotShowDetails();
	void slotQueryDetails();
	void slotDetailsClosed();

protected:
     void resizeEvent(QResizeEvent *);

private: // Methods
	void initMenu();

private:
	KAboutData *_aboutData;
    KConfig *ksConfig;
    QWidget *mainView;
	QPixmap baseIcon;

signals:
	void sigUpdateIPTDoc( KMFIPTDoc* );
	void sigQueryDetails( bool );
	void sigUpdateRuleCount( const QString&, const QString&, int );
};

#endif
