/***************************************************************************
 *   Copyright (C) 2005 by Christian Hubinger   *
 *   e9806056@student.tuwien.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef _kmfiptinterface_H
#define _kmfiptinterface_H

#include <qstringlist.h>
#include <qstring.h>
#include <dcopobject.h>

class KMFIPTInterface :  public DCOPObject
{
	K_DCOP

	private:
		QStringList m_List;

	public:
		KMFIPTInterface();

		~KMFIPTInterface();

	k_dcop:
		QString string(int);
		QStringList list();

		void add(QString);
		bool remove(QString);
		bool exit();
		
		void Test();
		int numRulesInChain( QString, QString ); 
		int numChainsInTable( QString );
		QStringList getChainsInTable( QString );
		QStringList getRuleProperties( QString, QString, int );

		QString getChainPolicy( QString, QString );
};
#endif
