/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _POTRACEGUI_H_
#define _POTRACEGUI_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <kapplication.h>

#include <qlabel.h>

class KToggleAction;
class MainWidget;

/**
 * @short Application Main Window
 * @author Antonio Fasolato <Antonio.Fasolato@poste.it>
 * @version 1.0
 *
 * This is potracegui main window. It controls the menu, the toolbar and the statusbar. Its main widget (MainWidget object) copes with the actual options gaining and image tracing.
 */
class potracegui : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * @short Default Constructor
	  *
	  * Nothing special.
     */
    potracegui();

    /**
     * @short Default Destructor
	  *
	  * Nothing special
     */
    virtual ~potracegui();
	 
private:
	MainWidget *m_centralWidget; /**< Main widget: everithing not related to menu, toolbar or statusbar */
	KToggleAction *m_toolbarAction; /**< Action for showing/hiding the toolbar */
	KToggleAction *m_statusbarAction; /**< Action for showing/hiding the statusbar */

	//! Connects all the signals and calls createGUI()
	void createInterface();
	//! If the window is being closed with unsaved changes to the document
	/*!
	 * Asks the user if he wants to save the document if he is closing the window and there are unsaved changes
	 */
	bool queryClose();

// Menu and toolbar operations
private slots:
	//! Used to create a new document (new window)
	void fileNew();
	//! Used when exiting the app
	void quit();
	
	//! Used to show/hide the toolbar
	void showToolbar();
	//! Used to show/hide the statusbar
	void showStatusbar();
	//! Used to call the key configuration dialog
	void configureKeys();
	//! Used to call the toolbar configuration dialog
	void configureTB();
	//! Used to update the toolbar after having changed it
	void NewTBConfig();
	//! Used to set a message in the statusbar (used by MainWidget)
	/*!
	 * \param message The message to show
	*/
	void changeStatusbar(QString message);
};

#endif // _POTRACEGUI_H_
