// KDE includes

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kuniqueapplication.h>

#include "app.h"

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

int main(int argc, char *argv[])
{

    KLocale::setMainCatalogue("adept_installer");

    putenv( "QT_IM_MODULE=xim" );
    QString description = i18n("Adept Installer");

    KAboutData aboutData( "adept_installer",
                          I18N_NOOP("Adept Installer"),
                          "2.1 Cruiser",
                          description.latin1(),
                          KAboutData::License_BSD,
                          I18N_NOOP("(c) 2005, 2006 Peter Rockai"),
                          0,
                          "http://web.mornfall.net/adept.html");

    aboutData.addAuthor ( "Peter Rockai",
                          I18N_NOOP("developer"),
                          "me at mornfall dot net",
                          "http://web.mornfall.net");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication app;

    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

    KGlobal::locale()->insertCatalogue(QString::fromUtf8("libept"));

    App *ta = new App();

    app.setMainWidget(ta);
    ta->show();

    return app.exec();
}
