/* -*- C++ -*- */
#ifndef APP_H
#define APP_H

#include <kmainwindow.h>
#include <kparts/part.h>
#include <kactionclasses.h>
#include <kcmdlineargs.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <adept/view.h>
#include <adept/commitprogress.h>
#include <adept/application.h>

#include <adept/acqprogresswidget.h>

class QVBox;
class QWidgetStack;
class QSplitter;
class KAction;
class KPushButton;
namespace adept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace adept;

class App : public KMainWindow, Application {
    Q_OBJECT
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	App( KCmdLineArgs *a );
signals:
  void imDone();
protected slots:
    void delayed();
  void handleDone();
protected:
    friend class WaitForLister;

    QWidgetStack *m_stack;
    QVBox *m_all;

    // stacked widgets
    adept::AcqProgressWidget *m_progress;
    adept::CommitProgress *m_commitProgress;

    bool updating;
};

#endif
