#include <qvbox.h>
#include <qlabel.h>
#include <qsplitter.h>
#include <qtimer.h>
#include <qwidgetstack.h>

#include <kpushbutton.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kaction.h>
#include <kactionclasses.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kparts/part.h>
#include <ktrader.h>
#include <klibloader.h>
#include <kstatusbar.h>

#include <apt-pkg/packagemanager.h>
#include <apt-front/manager.h>
#include <apt-front/init.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <apt-front/predicate/factory.h>

#include <adept/acqprogresswidget.h>
#include <adept/progress.h>
#include <adept/utils.h>

#include <iostream>

#include "app.h"

using namespace aptFront;
using namespace aptFront::cache;
using namespace adept;

App::App( KCmdLineArgs *args ) {
    setMainWidget( this );
    initialize();
    QString qs_pkgname;

    updating = false;
    enum { None, Remove, Install } m = None;
    for(int i = 0; i < args->count(); i++) {
        QCString a = args->arg( i );

        if (m == None ||
            cache().packages().packageByName( std::string( a ) ).valid()) {
          if ( m == Install ) {
            kdDebug() << "installing " << a << endl;
            cache().packages().packageByName( std::string( a ) ).markInstall();
          } else if ( m == Remove ) {
            kdDebug() << "removing " << a << endl;
            cache().packages().packageByName( std::string( a ) ).markRemove();
          }

          if ( m == None && a == "install" ) {
            m = Install;
          } if ( m == None && a == "remove" ) {
            m = Remove;
          } if ( m == None && a == "update" ) {
            updating = true;
          }
        } else {
          qs_pkgname = a;
          kdDebug() << "The package '"<<a<<"' could not be found." << endl;
          KMessageBox::sorry(
                             this, i18n( "The package '%1' could not be found." ).arg(u8(qs_pkgname)),
                             i18n( "Could not commit changes" ) );
          exit(1);
        }
    }

    if (!updating && m == 0) {
      exit( 1 );
    }

    observeComponent< component::State >();

    m_all = new QVBox( this );
    m_stack = new QWidgetStack( m_all );

    m_stack->addWidget( m_progress = new adept::AcqProgressWidget( m_stack ) );
    m_stack->addWidget( m_commitProgress = new CommitProgress( m_stack ) );

    connect(this, SIGNAL( imDone() ),
            this, SLOT( handleDone() ));

    setStandardToolBarMenuEnabled( false );
    createStandardStatusBarAction();
    setupGUI( Keys|StatusBar|Save|Create );
    delete toolBar();

    Application::setStatusBar( statusBar() );

    QTimer::singleShot(
        0, this,
        SLOT( delayed() ) );

    m_stack->raiseWidget( m_progress );
    setCentralWidget( m_all );
}

void App::delayed() {
    statusBar()->clear();

    kdDebug() << "App::delayed starting commit" << endl;

    aptFront::Manager m;
    m.setProgressCallback( m_progress->callback() );
    m.setUpdateInterval( 100000 );
    try {
      if (updating) {
        m_stack->raiseWidget( m_progress );
        m.update();
      } else {
        m_stack->raiseWidget( m_progress );
        m.download();
        m_stack->raiseWidget( m_commitProgress );
        m.commit();
      }
      emit imDone();
    } catch ( exception::OperationCancelled ) {
        emit imDone();
    } catch ( ... ) {
        KMessageBox::sorry(
            this, i18n( "There was an error commiting changes. "
                        "Possibly there was a problem downloading some "
                        "packages or the commit would break packages. " ),
            i18n( "Could not commit changes" ) );
        emit imDone();
    }
}

void App::handleDone() {
  kdDebug() << "I'm done here" << endl;
  close();
}

#include "app.moc"
