/* -*- C++ -*- */
#ifndef CHANGELOG_H
#define CHANGELOG_H

#include <qobject.h>
#include <qstring.h>
#include <qhttp.h>
#include <qbuffer.h>

#include <adept/lister.h>

#ifdef KUBUNTU
#define BASE_CHANGELOG_HOST "changelogs.ubuntu.com"
#define BASE_CHANGELOG_PORT 80
#define BASE_CHANGELOG_URL "/changelogs/pool"

namespace adept {

  class ItemChangelog : public QObject {
  Q_OBJECT
  public:
    ItemChangelog();
    ~ItemChangelog();

    // Give me the changelog's URL
    QString changelogUrl();
    void setParent(entity::Package parent) { m_pkg = parent; }
  signals:
    void changelogNeeded();
    void changelogReady(QString content);

  protected slots:
    // Give me the changelog's text
    void requestChangelog();
    void contentReady(int id, bool error);

  protected:
    entity::Package m_pkg;
    QHttp* m_http;
    QBuffer* m_content_catcher;
  };
}

#endif /* KUBUNTU */
#endif /*CHANGELOG_H*/
