/* -*- C++ -*- */
#include <qstring.h>
#include <qstringlist.h>
#include <qhttp.h>
#include <qbuffer.h>

#include <kdebug.h>

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>

#include <adept/lister.h>

#include "changelog.h"

using namespace adept;

#ifdef KUBUNTU
ItemChangelog::ItemChangelog() {
  connect(this, SIGNAL( changelogNeeded() ),
          this, SLOT( requestChangelog() ));
  m_http = 0;
  m_content_catcher = 0;
}

ItemChangelog::~ItemChangelog() {
  if (m_http != 0) {
    delete m_http;
  }
  if (m_content_catcher != 0) {
    delete m_content_catcher;
  }
}

/*
 * So this method is *very* specific to the ubuntu package
 * changelog repository.  If you want to modify this to meet the needs
 * of another distro, you may want to implement your own method here.
 */
QString ItemChangelog::changelogUrl() {
  // The list of known sections...
  QStringList knownSections(QString("main"));
  knownSections += QString("multiverse");
  knownSections += QString("restricted");
  knownSections += QString("universe");

  // The parts of the package that form the URL...
  QStringList pkgParts( QString(BASE_CHANGELOG_URL) );
  QStringList sectionParts;
  QString section;
  QString urlBase;
  QString pkgName;
  bool found = false;

  try {
    if (&m_pkg == 0x0) {
      throw 0;
    }
    std::string theSection(m_pkg.section(std::string("/")));
    if (!theSection.length()) {
      throw 0;
    }
    //// Get the section
    section = QString( theSection );
    /* now convert the section into something
       usable for the changelog URL. */
    sectionParts = QStringList::split(QString("/"), section);

    /* If we have more than one piece, that means we've got a
       non-main repo.  Let's make sure it's one we can use. */
    if (sectionParts.size() > 1) {
      // Walk through known sections
      for (QStringList::Iterator it = knownSections.begin();
           it != knownSections.end(); ++it) {
        // If we found it, let's say we found it.
        if (sectionParts[0] == *it) {
          pkgParts += sectionParts[0];
          found = true;
          break;
        }
      }
      if (!found) {
        return QString::null; // didn't find the repo!
      }
    } else {
      pkgParts += QString("main");
    }

    //// Get the package name and prefix
    pkgName += QString( m_pkg.source() );
    pkgParts += QString(pkgName[0]);
    pkgParts += pkgName;

    //// Get the version string.
    QString version = QString( m_pkg.candidateVersion().versionString() );
    int epoch = version.find(':');
    if (epoch > -1) {
      version = version.mid(epoch + 1);
    }
    pkgName += "_" + version;
    pkgParts += pkgName;
    pkgParts += QString("changelog");

    return pkgParts.join(QString("/"));
  } catch (...) {
    kdDebug() << "GOT ME AN EXCEPTION!!!! THIS IS NOT GOOD!!!!";
  }

  return QString::null;
}

void ItemChangelog::requestChangelog() {
//   emit changelogReady(changelogUrl());

//   return;

  /* Removing temporarilly */
  m_http = new QHttp(QString(BASE_CHANGELOG_HOST),
                     BASE_CHANGELOG_PORT,
                     this, "changelog_loader");
  connect(dynamic_cast<QObject*>(m_http), SIGNAL( requestFinished(int,bool) ),
          dynamic_cast<QObject*>(this), SLOT( contentReady(int,bool) ));
  m_content_catcher = new QBuffer();
  QString theUrl( changelogUrl() );

  if ( theUrl == QString::null ) {
    emit changelogReady(QString("No change log found."));
  } else {
    m_http->get( changelogUrl(), dynamic_cast<QIODevice*>(m_content_catcher) );
  }
}

void ItemChangelog::contentReady( int id, bool error ) {
  QString msg("Unable to fetch the Developer Changelog.");

  if (!error) {
    msg = QString( m_content_catcher->buffer() );
  } else {
    msg += ": " + m_http->errorString();
  }

  emit changelogReady( msg );
}

#endif /*KUBUNTU*/
