/***************************************************************************
    smb4ksystemtray  -  This is the system tray window class of Smb4K.
                             -------------------
    begin                : Mi Jun 13 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSYSTEMTRAY_H
#define SMB4KSYSTEMTRAY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <ksystemtray.h>
#include <kactionclasses.h>

class Smb4KSystemTray : public KSystemTray
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent        The parent widget of the system tray window
     *
     * @param name          The name of the system tray window
     */
    Smb4KSystemTray( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSystemTray();

    /**
     * Embeds the system tray window into the system tray, if @p ebd is
     * TRUE. Otherwise, it removes it from there. Note, that the system tray
     * icon won't be deleted but only hidden!
     *
     * @param ebd           If TRUE the system tray icon will be embedded into
     *                      the system tray.
     */
    void embed( bool ebd );

    /**
     * This function returns TRUE if the system tray window is embedded into
     * the system tray and FALSE otherwise.
     *
     * @returns TRUE if the system tray window is embedded.
     */
    bool isEmbedded() { return isShown(); }

    /**
     * This function (re-)loads the settings for this widget. It basically just
     * runs the slot slotSetupBookmarkMenu() and slotSetupSharesMenu(), that will
     * do everything to properly set up the menus.
     *
     * This slot *does not* manage the appearance (or disappearance) of this widget
     * in the system tray. You need to use embed() to do this.
     */
    void loadSettings();

  signals:
    /**
     * This signal is emitted when the config dialog has been closed and the
     * settings changed.
     */
    void settingsChanged();

  protected slots:
    /**
     * This slot opens the dialog for mounting shares manually.
     */
    void slotMountManually();

    /**
     * This slot opens the configurations dialog.
     */
    void slotConfigDialog();

    /**
     * This slot is invoked when the config dialog is closed and the settings have
     * been changed. Emits the reloadSettings() signal and adjusts the system tray
     * widget to the new settings afterwards.
     */
    void slotSettingsChanged();

    /**
     * This slot is invoked when the bookmarks have been updated. It sets up the
     * bookmark menu, inserts the bookmark actions into it and automatically
     * disables them if they were already mounted (@see slotSetupSharesMenu() as well).
     */
    void slotSetupBookmarksMenu();

    /**
     * This slot opens the bookmark editor.
     */
    void slotBookmarkEditor();

    /**
     * This slot is called when a bookmark has been activated. It initializes the
     * mounting of the represented share.
     */
    void slotBookmarkActivated();

    /**
     * This slot enables and disables the bookmarks. If a share that's represented
     * by the bookmark is mounted, the bookmark will be disabled. It will be
     * enabled, when it is unmounted again.
     */
    void slotEnableBookmarks();

    /**
     * This slot is activated when the list of mounted shares has been updated.
     * It setus up the "Mounted Shares" menu and also enables/disables the
     * bookmarks in the "Bookmarks" menu. It is connected to the
     * Smb4KMounter::updated() signal.
     */
    void slotSetupSharesMenu();

    /**
     * This slot initializes the umounting of all shares. It is connected to the
     * "Unmount All" action of the "Mounted Shares" menu.
     */
    void slotUnmountAllShares();

    /**
     * This slot is connected to the 'Unmount action'. You will be able to
     * unmount a certain share when activating this slot.
     */
    void slotUnmountShare();

    /**
     * This slot is connected to the 'Force Unmounting' action and is, thus,
     * only useful under Linux, because only there the possibility for a forced
     * (i.e. lazy) unmount exists.
     *
     * When activating this slot, the selected share will be unmounted, even if
     * it is not accessible or the server already went offline.
     */
    void slotForceUnmountShare();

    /**
     * This slot is connected to the 'Synchronize' action. The current item will be
     * synchronized with a local copy (or vice versa) if you activate it.
     */
    void slotSynchronize();

    /**
     * This slot is connected to the 'Konsole' action. The mount point of the current
     * share item will be opened in Konsole.
     */
    void slotKonsole();

    /**
     * This slot is connected to the 'Konqueror' action. The contents of the current
     * share item will be opened in the file manager.
     */
    void slotFilemanager();

    /**
     * This slot is enabled when an action is highlighted.  No validity checks are
     * performed.
     *
     * @param action        The currently highlighted action.
     */
    void slotActionHighlighted( KAction *action );

  private:
    /**
     * The action menu for the bookmarks.
     */
    KActionMenu *m_bookmarks_menu;

    /**
     * The action menu for the mounted shares.
     */
    KActionMenu *m_shares_menu;

    /**
     * This is the currently highlighted action.
     */
    KAction *m_action;
};

#endif
