/***************************************************************************
    smb4ksearchdialogitem  -  This class is an enhanced version of a list
    box item for Smb4K.
                             -------------------
    begin                : So Jun 3 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qimage.h>

// KDE includes
#include <kiconloader.h>
#include <kiconeffect.h>
#include <klocale.h>

// application specific includes
#include "smb4ksearchdialogitem.h"
#include "smb4ksearchdialog.h"
#include "../core/smb4knetworkitems.h"


Smb4KSearchDialogItem::Smb4KSearchDialogItem( KListView *listView, Smb4KHostItem *item, int serial )
: KListViewItem( listView ), m_item( *item ), m_serial( serial )
{
  m_is_known = false;

  if ( !m_item.name().isEmpty() )
  {
    m_is_regular = true;

    QString item_text = m_item.name();

    if ( !m_item.workgroup().isEmpty() && !m_item.ip().isEmpty() )
    {
      item_text.append( " ["+m_item.workgroup()+", "+m_item.ip()+"]" );
    }
    else
    {
      if ( !m_item.workgroup().isEmpty() )
      {
        item_text.append( " ["+m_item.workgroup()+"]" );
      }
      else if ( !m_item.ip().isEmpty() )
      {
        // This case will most likely never appear.
        item_text.append( " ["+m_item.ip()+"]" );
      }
      else
      {
        // Add nothing to the item text.
      }
    }

    setText( 0, item_text );
    setIcon();
  }
  else
  {
    m_is_regular = false;

    setText( 0, i18n( "The search failed." ) );
    setIcon();
  }
}


Smb4KSearchDialogItem::~Smb4KSearchDialogItem()
{
}


void Smb4KSearchDialogItem::setIcon()
{
  if ( m_is_regular )
  {
    if ( m_is_known )
    {
      KIconEffect e;
      QImage over = SmallIcon( "button_ok" ).convertToImage();
      QImage src = SmallIcon( "server" ).convertToImage();
      e.semiTransparent( over );
      e.overlay( src, over );

      QPixmap pix( src );

      setPixmap( 0, pix );
    }
    else
    {
      setPixmap( 0, SmallIcon( "server" ) );
    }
  }
  else
  {
    setPixmap( 0, SmallIcon( "no" ) );
  }
}


void Smb4KSearchDialogItem::setKnown( bool known )
{
  m_is_known = known;

  setIcon();
}


int Smb4KSearchDialogItem::compare( QListViewItem *i, int, bool ascending ) const
{
  Smb4KSearchDialogItem *item = static_cast<Smb4KSearchDialogItem *>( i );

  int result = 0;

  if ( item )
  {
    result = item->serialNumber() - serialNumber();
  }

  return (ascending ? result : -result);
}

