/***************************************************************************
    smb4ksharesiconviewitem  -  The items for Smb4K's shares icon view.
                             -------------------
    begin                : Di Dez 5 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESICONVIEWITEM_H
#define SMB4KSHARESICONVIEWITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qpainter.h>
#include <qpalette.h>

// KDE includes
#include <kiconview.h>
#include <kiconloader.h>

// application specific includes
#include "../core/smb4kshare.h"

// forward declarations
class Smb4KSharesIconView;

/**
 * This class provides the items for the shares icon view
 * of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesIconViewItem : public KIconViewItem
{
  public:
    /**
     * The constructor.
     *
     * @param share         The Smb4KShare object that represents the share.
     *
     * @param mountpoint    Tells the item if the mount point instead of the
     *                      share name should be shown. Default is FALSE.
     *
     * @param parent        The parent widget of this item.
     */
    Smb4KSharesIconViewItem( Smb4KShare *share,
                             bool mountpoint = false,
                             Smb4KSharesIconView *parent = 0 );

    /**
     * The destructor
     */
    ~Smb4KSharesIconViewItem();

    /**
     * This function compares the encapsulated Smb4KShare object with @p item
     * and returns TRUE if they contain equal values.
     *
     * @param item          A Smb4KShare object that should be compared
     *
     * @returns             TRUE if @p item has the same values stored as the
     *                      encapsulated Smb4KShare object.
     */
    bool sameShareObject( Smb4KShare *share );

    /**
     * Replace the encapsulated Smb4KShare object. This function just passes
     * the share object to setupItem() which does all the work.
     *
     * @param share         The new Smb4KShare object
     */
    void replaceShareObject( Smb4KShare *share );

    /**
     * Returns a pointer to the share object that's represented by this item.
     * You have to use it to access its data.
     *
     * @returns a pointer to a Smb4KShare object.
     */
    Smb4KShare *shareObject() { return &m_share; }

    /**
     * This function returns the desktop pixmap of this item.
     *
     * @returns the destop pixmap of this item.
     */
    const QPixmap &desktopPixmap() { return m_pixmap; }

  protected:
    /**
     * Reimplemented from QIconViewItem.
     *
     * This function paints the icon text and uses Smb4KShare::isForeign() to
     * determine the color (TRUE: gray, FALSE: the default color).
     *
     * @param p             The painter
     *
     * @param cg            The color group
     */
    void paintItem( QPainter *p,
                    const QColorGroup &cg );

    /**
     * Reimplemented from QIconViewItem.
     *
     * This function accepts or denies drops according to the contents of @p source.
     *
     * @param source        The mime source
     */
    bool acceptDrop( const QMimeSource *source ) const;

  private:
    /**
     * Set up the icon and text of the item with resepect to @p share and @p mountpoint.
     *
     * @param share         The Smb4KShare object.
     *
     * @param mountpoint    If TRUE, the mount point will be shown instead of the
     *                      share name.
     */
    void setupItem( const Smb4KShare &share,
                    bool mountpoint = false );

    /**
     * The Smb4KShare object representing the share.
     */
    Smb4KShare m_share;

    /**
     * Tells us if the mount point instead of the share
     * name should be shown.
     */
    bool m_mountpoint;

    /**
     * Tells us that the initial setup already happened.
     */
    bool m_initial_setup;

    /**
     * The icon loader for this item.
     */
    KIconLoader *m_loader;

    /**
     * The desktop pixmap
     */
    QPixmap m_pixmap;
};

#endif

